/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.core;

import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.core.AFK;
import de.scholle.essentiax.core.ConfigHelper;
import de.scholle.essentiax.core.Language;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;

public class AFKSpot
implements CommandExecutor {
    private final EssentiaX plugin;
    private final AFK afk;
    private final Language lang;

    public AFKSpot(EssentiaX plugin, AFK afk, Language lang) {
        this.plugin = plugin;
        this.afk = afk;
        this.lang = lang;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("essentia.afkspot")) {
            return true;
        }
        if (!ConfigHelper.getSafeBoolean((Configuration)this.plugin.getConfig(), "afk.afkspot.enabled", false)) {
            player.sendMessage(this.lang.get("afkspot.disabled"));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.lang.get("afkspot.usage"));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "set": {
                Location loc = player.getLocation();
                this.afk.setAfkSpot(loc);
                player.sendMessage(this.lang.get("afkspot.set"));
                break;
            }
            case "delete": {
                this.afk.deleteAfkSpot();
                player.sendMessage(this.lang.get("afkspot.delete"));
                break;
            }
            default: {
                player.sendMessage(this.lang.get("afkspot.usage"));
            }
        }
        return true;
    }
}

