/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.core;

import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.core.ActionBarUtil;
import de.scholle.essentiax.core.ConfigHelper;
import de.scholle.essentiax.core.Language;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AFK
implements CommandExecutor,
Listener {
    private final EssentiaX plugin;
    private final Language lang;
    private final ActionBarUtil actionBarUtil;
    private final Map<UUID, Long> afkDelayMap = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> afkActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, Location> previousLocations = new HashMap<UUID, Location>();
    private Location afkSpot = null;

    public AFK(EssentiaX plugin, Language lang) {
        this.plugin = plugin;
        this.lang = lang;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        String serverType = plugin.getConfig().getString("afk.server-type", "paper");
        this.actionBarUtil = new ActionBarUtil(serverType);
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.afkDelayMap.containsKey(player.getUniqueId())) {
            this.afkDelayMap.remove(player.getUniqueId());
            player.sendMessage(this.lang.get("afk.canceled_damage"));
            this.sendNotAfkActionbar(player);
            return;
        }
        if (this.afkActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.afkDelayMap.containsKey(player.getUniqueId())) {
            if (!event.getFrom().getBlock().equals(event.getTo().getBlock())) {
                this.afkDelayMap.remove(player.getUniqueId());
                player.sendMessage(this.lang.get("afk.canceled_move"));
                this.sendNotAfkActionbar(player);
            }
            return;
        }
        if (this.afkActive.getOrDefault(player.getUniqueId(), false).booleanValue() && !event.getFrom().toVector().equals((Object)event.getTo().toVector())) {
            this.afkActive.remove(player.getUniqueId());
            player.setCollidable(true);
            Location prev = this.previousLocations.remove(player.getUniqueId());
            if (prev != null) {
                event.setCancelled(true);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.teleport(prev));
            }
            this.sendNotAfkActionbar(player);
            player.sendMessage(this.lang.get("afk.canceled_move"));
        }
    }

    @EventHandler
    public void onVelocity(PlayerVelocityEvent event) {
        Player player = event.getPlayer();
        if (this.afkActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        final Player player = (Player)sender;
        if (!ConfigHelper.getSafeBoolean((Configuration)this.plugin.getConfig(), "afk.enabled", true)) {
            player.sendMessage(this.lang.get("afk.disabled"));
            return true;
        }
        if (!player.hasPermission("essentia.afk")) {
            return true;
        }
        final int afkDelay = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "afk.afk-delay", 5);
        this.afkDelayMap.put(player.getUniqueId(), System.currentTimeMillis() + (long)afkDelay * 1000L);
        player.sendMessage(this.lang.get("afk.start", Map.of("seconds", String.valueOf(afkDelay))));
        new BukkitRunnable(){
            int seconds;
            {
                this.seconds = afkDelay;
            }

            public void run() {
                if (!player.isOnline() || !AFK.this.afkDelayMap.containsKey(player.getUniqueId())) {
                    this.cancel();
                    return;
                }
                AFK.this.actionBarUtil.sendActionBar(player, AFK.this.lang.get("afk.countdown", Map.of("seconds", String.valueOf(this.seconds))));
                --this.seconds;
                if (this.seconds <= 0) {
                    AFK.this.afkDelayMap.remove(player.getUniqueId());
                    AFK.this.afkActive.put(player.getUniqueId(), true);
                    player.setCollidable(false);
                    if (ConfigHelper.getSafeBoolean((Configuration)AFK.this.plugin.getConfig(), "afk.afkspot.enabled", false) && AFK.this.afkSpot != null) {
                        AFK.this.previousLocations.put(player.getUniqueId(), player.getLocation());
                        player.teleport(AFK.this.afkSpot);
                    }
                    if (ConfigHelper.getSafeBoolean((Configuration)AFK.this.plugin.getConfig(), "afk.actionbar.enabled", true)) {
                        AFK.this.actionBarUtil.sendActionBar(player, AFK.this.lang.get("afk.actionbar"));
                    }
                    player.sendMessage(AFK.this.lang.get("afk.now"));
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
        return true;
    }

    private void sendNotAfkActionbar(Player player) {
        if (ConfigHelper.getSafeBoolean((Configuration)this.plugin.getConfig(), "afk.actionbar.enabled", true)) {
            this.actionBarUtil.sendActionBar(player, this.lang.get("afk.not_afk"));
        }
    }

    public void setAfkSpot(Location location) {
        this.afkSpot = location;
    }

    public void deleteAfkSpot() {
        this.afkSpot = null;
    }

    public boolean isAfk(Player player) {
        return this.afkActive.getOrDefault(player.getUniqueId(), false);
    }

    public void removeAfk(Player player) {
        this.afkActive.remove(player.getUniqueId());
        player.setCollidable(true);
    }
}

