/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.core;

import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.core.ConfigHelper;
import de.scholle.essentiax.core.Language;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Back
implements CommandExecutor,
Listener {
    private final EssentiaX plugin;
    private final Language lang;
    private final Map<UUID, Location> deathPoints = new HashMap<UUID, Location>();
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public Back(EssentiaX plugin, Language lang) {
        this.plugin = plugin;
        this.lang = lang;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.deathPoints.put(player.getUniqueId(), player.getLocation());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        long remaining;
        if (!(sender instanceof Player)) {
            return true;
        }
        final Player player = (Player)sender;
        if (!ConfigHelper.getSafeBoolean((Configuration)this.plugin.getConfig(), "back.enabled", true)) {
            player.sendMessage(this.lang.get("back.disabled"));
            return true;
        }
        if (!player.hasPermission("essentia.back")) {
            return true;
        }
        final Location lastDeath = this.deathPoints.get(player.getUniqueId());
        if (lastDeath == null) {
            player.sendMessage(this.lang.get("back.not_found"));
            return true;
        }
        final int standTime = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "back.stand-still-time", 3);
        int cooldownTime = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "back.cooldown", 10);
        long now = System.currentTimeMillis();
        if (this.cooldowns.containsKey(player.getUniqueId()) && (remaining = (this.cooldowns.get(player.getUniqueId()) + (long)cooldownTime * 1000L - now) / 1000L) > 0L) {
            player.sendMessage(this.lang.get("back.cooldown").replace("%seconds%", String.valueOf(remaining)));
            return true;
        }
        final Location initial = player.getLocation();
        player.sendMessage(this.lang.get("back.stand").replace("%seconds%", String.valueOf(standTime)));
        new BukkitRunnable(){
            int seconds;
            {
                this.seconds = standTime;
            }

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                if (!player.getLocation().getBlock().getLocation().equals((Object)initial.getBlock().getLocation())) {
                    player.sendMessage(Back.this.lang.get("back.canceled"));
                    this.cancel();
                    return;
                }
                if (this.seconds <= 0) {
                    player.teleport(lastDeath);
                    player.sendMessage(Back.this.lang.get("back.tp"));
                    Back.this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
                    this.cancel();
                }
                --this.seconds;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        return true;
    }
}

