/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy;

import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.extras.economy.EssentiaXEconomy;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Balance
implements CommandExecutor {
    private final EssentiaXEconomy essentiaXEconomy;
    private final EssentiaX plugin;

    public Balance(EssentiaX plugin, EssentiaXEconomy essentiaXEconomy) {
        this.plugin = plugin;
        this.essentiaXEconomy = essentiaXEconomy;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cOnly players can use this command without arguments.");
                return true;
            }
            Player player = (Player)sender;
            if (!sender.hasPermission("essentiax.extras.economy.balance")) {
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
            double balance = this.essentiaXEconomy.getBalance((OfflinePlayer)player);
            sender.sendMessage("\u00a7aYour balance: \u00a7e" + this.essentiaXEconomy.format(balance));
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("top")) {
                if (!sender.hasPermission("essentiax.extras.economy.balance.top")) {
                    sender.sendMessage("\u00a7cYou do not have permission to see the top balances.");
                    return true;
                }
                sender.sendMessage("\u00a76--- \u00a7eTop Balances \u00a76---");
                List top = this.essentiaXEconomy.getAllPlayers().stream().sorted(Comparator.comparingDouble(this.essentiaXEconomy::getBalance).reversed()).limit(10L).collect(Collectors.toList());
                for (int i = 0; i < top.size(); ++i) {
                    OfflinePlayer p = (OfflinePlayer)top.get(i);
                    String name = p.getName() != null ? p.getName() : "Unknown";
                    double bal = this.essentiaXEconomy.getBalance(p);
                    sender.sendMessage("\u00a7e#" + (i + 1) + " \u00a7f" + name + ": \u00a7a" + this.essentiaXEconomy.format(bal));
                }
                return true;
            }
            if (!sender.hasPermission("essentiax.extras.economy.balance.other")) {
                sender.sendMessage("\u00a7cYou do not have permission to see other players' balances.");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                sender.sendMessage("\u00a7cPlayer not found.");
                return true;
            }
            double balance = this.essentiaXEconomy.getBalance((OfflinePlayer)target);
            sender.sendMessage("\u00a7f" + target.getName() + "'s balance: \u00a7a" + this.essentiaXEconomy.format(balance));
            return true;
        }
        return false;
    }
}

