/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy;

import de.scholle.essentiax.extras.economy.EssentiaXEconomy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EconomyAdmin
implements CommandExecutor {
    private final EssentiaXEconomy essentiaXEconomy;

    public EconomyAdmin(EssentiaXEconomy essentiaXEconomy) {
        this.essentiaXEconomy = essentiaXEconomy;
        this.registerAlias();
    }

    private void registerAlias() {
        Bukkit.getPluginCommand((String)"ecoa").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!sender.hasPermission("essentia.extras.economy.op")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length != 3) {
            sender.sendMessage("\u00a7eUsage: /" + label + " <set/add/remove> <player> <amount>");
            return true;
        }
        String action = args[0];
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found.");
            return true;
        }
        try {
            amount = Double.parseDouble(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid amount.");
            return true;
        }
        switch (action.toLowerCase()) {
            case "set": {
                this.essentiaXEconomy.setBalance((OfflinePlayer)target, amount);
                sender.sendMessage("\u00a7aSet " + target.getName() + "'s balance to " + this.essentiaXEconomy.format(amount));
                break;
            }
            case "add": {
                this.essentiaXEconomy.addBalance((OfflinePlayer)target, amount);
                sender.sendMessage("\u00a7aAdded " + this.essentiaXEconomy.format(amount) + " to " + target.getName());
                break;
            }
            case "remove": {
                this.essentiaXEconomy.removeBalance((OfflinePlayer)target, amount);
                sender.sendMessage("\u00a7aRemoved " + this.essentiaXEconomy.format(amount) + " from " + target.getName());
                break;
            }
            default: {
                sender.sendMessage("\u00a7cInvalid action. Use set/add/remove.");
            }
        }
        return true;
    }
}

