/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Chat
implements Listener,
CommandExecutor {
    private final JavaPlugin plugin;
    private final FileConfiguration extrasConfig;
    private final ConcurrentHashMap<UUID, Long> lastMessageTime = new ConcurrentHashMap();

    public Chat(JavaPlugin plugin) {
        this.plugin = plugin;
        this.extrasConfig = YamlConfiguration.loadConfiguration((File)this.createExtrasFile());
        this.loadAutoClearTask();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        plugin.getCommand("clearchat").setExecutor((CommandExecutor)this);
    }

    private File createExtrasFile() {
        File extrasFile = new File(this.plugin.getDataFolder(), "extras.yml");
        if (!extrasFile.exists()) {
            extrasFile.getParentFile().mkdirs();
            this.plugin.saveResource("extras.yml", false);
        }
        return extrasFile;
    }

    private void loadAutoClearTask() {
        if (this.extrasConfig.getBoolean("clearchat.auto.enabled", false)) {
            int intervalMinutes = this.extrasConfig.getInt("clearchat.auto.interval", 60);
            new BukkitRunnable(){

                public void run() {
                    Chat.this.clearChat();
                }
            }.runTaskTimer((Plugin)this.plugin, (long)intervalMinutes * 60L * 20L, (long)intervalMinutes * 60L * 20L);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        boolean slowChatEnabled = this.extrasConfig.getBoolean("slowchat.enabled", false);
        int cooldown = this.extrasConfig.getInt("slowchat.cooldown_seconds", 5);
        Player player = event.getPlayer();
        if (slowChatEnabled && !player.hasPermission("essentiax.slowchat.bypass")) {
            long last;
            long now = System.currentTimeMillis();
            if (now - (last = this.lastMessageTime.getOrDefault(player.getUniqueId(), 0L).longValue()) < (long)cooldown * 1000L) {
                long wait = ((long)cooldown * 1000L - (now - last)) / 1000L;
                player.sendMessage(ChatColor.RED + "Slowchat is enabled! Please wait " + wait + " seconds.");
                event.setCancelled(true);
                return;
            }
            this.lastMessageTime.put(player.getUniqueId(), now);
        }
    }

    private void clearChat() {
        for (int i = 0; i < 100; ++i) {
            Bukkit.broadcastMessage((String)"");
        }
        Bukkit.broadcastMessage((String)(ChatColor.GREEN + "Chat has been cleared!"));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("clearchat")) {
            return false;
        }
        boolean clearchatEnabled = this.extrasConfig.getBoolean("clearchat.enabled", true);
        if (!clearchatEnabled) {
            sender.sendMessage(ChatColor.RED + "ClearChat command is disabled in the config.");
            return true;
        }
        if (!sender.hasPermission("essentiax.clearchat")) {
            sender.sendMessage(ChatColor.RED + "You do not have permission to use this command.");
            return true;
        }
        this.clearChat();
        return true;
    }
}

