/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP;

import com.maybeizen.EasyRTP.commands.EasyRTPCommand;
import com.maybeizen.EasyRTP.commands.RTPCommand;
import com.maybeizen.EasyRTP.commands.RTPOCommand;
import com.maybeizen.EasyRTP.listeners.PlayerMoveListener;
import com.maybeizen.EasyRTP.managers.CooldownManager;
import com.maybeizen.EasyRTP.managers.RTPManager;
import com.maybeizen.EasyRTP.utils.ConfigManager;
import com.maybeizen.EasyRTP.utils.DatabaseManager;
import com.maybeizen.EasyRTP.utils.MessageUtils;
import com.maybeizen.EasyRTP.utils.VersionAdapter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EasyRTP
extends JavaPlugin {
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private CooldownManager cooldownManager;
    private RTPManager rtpManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.configManager = ConfigManager.getInstance(this);
        MessageUtils.initialize(this);
        this.cooldownManager = new CooldownManager(this.configManager.getCooldown());
        this.rtpManager = new RTPManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        RTPCommand rtpCommand = new RTPCommand(this);
        this.getCommand("rtp").setExecutor((CommandExecutor)rtpCommand);
        this.getCommand("rtp").setTabCompleter((TabCompleter)rtpCommand);
        RTPOCommand rtpoCommand = new RTPOCommand(this);
        this.getCommand("rtpo").setExecutor((CommandExecutor)rtpoCommand);
        this.getCommand("rtpo").setTabCompleter((TabCompleter)rtpoCommand);
        EasyRTPCommand adminCommand = new EasyRTPCommand(this);
        this.getCommand("easyrtp").setExecutor((CommandExecutor)adminCommand);
        this.getCommand("easyrtp").setTabCompleter((TabCompleter)adminCommand);
        Bukkit.getLogger().info("EasyRTP has been enabled!");
        Bukkit.getLogger().info("Running on server version: " + VersionAdapter.getServerVersion());
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.databaseManager.closeConnection();
        }
        Bukkit.getLogger().info("EasyRTP has been disabled!");
    }

    public void reloadConfiguration() {
        this.reloadConfig();
        this.configManager.reloadConfig();
        this.cooldownManager = new CooldownManager(this.configManager.getCooldown());
        MessageUtils.initialize(this);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public RTPManager getRTPManager() {
        return this.rtpManager;
    }
}

