/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.commands;

import com.maybeizen.EasyRTP.EasyRTP;
import com.maybeizen.EasyRTP.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class EasyRTPCommand
implements CommandExecutor,
TabCompleter {
    private final EasyRTP plugin;

    public EasyRTPCommand(EasyRTP plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("easyrtp.admin")) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("no-permission")));
            return true;
        }
        if (args.length != 1 || !args[0].equalsIgnoreCase("reload")) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("admin-usage")));
            return true;
        }
        sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("config-reloading")));
        try {
            this.plugin.reloadConfiguration();
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("config-reloaded")));
        }
        catch (Exception e) {
            sender.sendMessage(MessageUtils.formatMessage("&cError reloading configuration: " + e.getMessage()));
            e.printStackTrace();
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1 && sender.hasPermission("easyrtp.admin") && "reload".startsWith(args[0].toLowerCase())) {
            completions.add("reload");
        }
        return completions;
    }
}

