/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.listeners;

import com.maybeizen.EasyRTP.EasyRTP;
import com.maybeizen.EasyRTP.managers.TitleManager;
import com.maybeizen.EasyRTP.utils.MessageUtils;
import com.maybeizen.EasyRTP.utils.VersionAdapter;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMoveListener
implements Listener {
    private final EasyRTP plugin;
    private final TitleManager titleManager;

    public PlayerMoveListener(EasyRTP plugin) {
        this.plugin = plugin;
        this.titleManager = new TitleManager(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getRTPManager().hasActiveTeleport(player.getUniqueId())) {
            return;
        }
        Location startLocation = this.plugin.getRTPManager().getTeleportStartLocation(player.getUniqueId());
        if (startLocation == null) {
            return;
        }
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        double horizontalDistance = Math.sqrt(Math.pow(to.getX() - startLocation.getX(), 2.0) + Math.pow(to.getZ() - startLocation.getZ(), 2.0));
        if (horizontalDistance > 0.5) {
            this.plugin.getRTPManager().cancelTeleportTask(player.getUniqueId());
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("teleport-cancelled")));
            this.titleManager.showCancelTitle(player);
            if (this.plugin.getConfigManager().getEnableCancelSound()) {
                VersionAdapter.playCancelSound(player, this.plugin.getConfigManager().getCancelSound());
            }
        }
    }
}

