/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.managers;

import com.maybeizen.EasyRTP.EasyRTP;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public class LocationFinder {
    private final EasyRTP plugin;
    private final Random random;

    public LocationFinder(EasyRTP plugin) {
        this.plugin = plugin;
        this.random = new Random();
    }

    public Location findRandomLocation(World world) {
        int maxAttempts = this.plugin.getConfigManager().getMaxAttempts();
        int minDistance = this.plugin.getConfigManager().getMinDistance();
        int maxDistance = this.plugin.getConfigManager().getMaxDistance();
        int centerX = this.plugin.getConfigManager().getCenterX();
        int centerZ = this.plugin.getConfigManager().getCenterZ();
        int minY = this.plugin.getConfigManager().getMinY();
        int maxY = this.plugin.getConfigManager().getMaxY();
        boolean safeLocationCheck = this.plugin.getConfigManager().getSafeLocationCheck();
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            boolean requireSkyVisibility;
            Location location;
            int z;
            int x = centerX + this.random.nextInt(maxDistance * 2) - maxDistance;
            double distance = Math.sqrt(x * x + (z = centerZ + this.random.nextInt(maxDistance * 2) - maxDistance) * z);
            if (distance < (double)minDistance || (location = this.findHighestSolidBlock(world, x, z, minY, maxY)) == null || safeLocationCheck && !this.isLocationSafe(location) || (requireSkyVisibility = this.plugin.getConfigManager().getRequireSkyVisibility()) && !this.hasSkyVisibility(location, world)) continue;
            return location;
        }
        return null;
    }

    private Location findHighestSolidBlock(World world, int x, int z, int minY, int maxY) {
        for (int y = maxY; y >= minY; --y) {
            Location location = new Location(world, (double)x, (double)y, (double)z);
            Material blockType = location.getBlock().getType();
            if (!blockType.isSolid() || blockType == Material.LAVA || blockType == Material.WATER) continue;
            Location playerLocation = location.clone().add(0.0, 1.0, 0.0);
            Location headLocation = location.clone().add(0.0, 2.0, 0.0);
            if (!playerLocation.getBlock().getType().isAir() || !headLocation.getBlock().getType().isAir()) continue;
            return playerLocation;
        }
        return null;
    }

    private boolean isLocationSafe(Location location) {
        Location[] checkLocations;
        for (Location checkLoc : checkLocations = new Location[]{location.clone().add(0.0, -1.0, 0.0), location.clone().add(1.0, 0.0, 0.0), location.clone().add(-1.0, 0.0, 0.0), location.clone().add(0.0, 0.0, 1.0), location.clone().add(0.0, 0.0, -1.0), location.clone().add(0.0, 1.0, 0.0), location.clone().add(0.0, 2.0, 0.0)}) {
            Material blockType = checkLoc.getBlock().getType();
            if (blockType != Material.LAVA && blockType != Material.FIRE && blockType != Material.CACTUS && blockType != Material.MAGMA_BLOCK && blockType != Material.WITHER_ROSE) continue;
            return false;
        }
        return location.getBlock().getType() != Material.WATER && location.getBlock().getType() != Material.LAVA;
    }

    private boolean hasSkyVisibility(Location location, World world) {
        int startY = location.getBlockY() + 1;
        int maxHeight = world.getMaxHeight();
        for (int y = startY; y < maxHeight; ++y) {
            Location checkLocation = new Location(world, (double)location.getBlockX(), (double)y, (double)location.getBlockZ());
            Material blockType = checkLocation.getBlock().getType();
            if (!blockType.isSolid()) continue;
            return false;
        }
        return true;
    }

    public void preloadChunks(Location location) {
        int radius = this.plugin.getConfigManager().getPreloadRadius();
        World world = location.getWorld();
        int centerChunkX = location.getBlockX() >> 4;
        int centerChunkZ = location.getBlockZ() >> 4;
        for (int x = centerChunkX - radius; x <= centerChunkX + radius; ++x) {
            for (int z = centerChunkZ - radius; z <= centerChunkZ + radius; ++z) {
                Chunk chunk = world.getChunkAt(x, z);
                if (chunk.isLoaded()) continue;
                chunk.load(true);
            }
        }
    }
}

