/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.utils;

import com.maybeizen.EasyRTP.EasyRTP;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ConfigManager {
    private static ConfigManager instance;
    private final EasyRTP plugin;
    private FileConfiguration config;

    private ConfigManager(EasyRTP plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public static ConfigManager getInstance(EasyRTP plugin) {
        if (instance == null) {
            instance = new ConfigManager(plugin);
        } else {
            instance.loadConfig();
        }
        return instance;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    private String getDefaultMessage(String path) {
        switch (path) {
            case "prefix": {
                return "&7[&6EasyRTP&7] &r";
            }
            case "player-only": {
                return "&cThis command can only be used by players.";
            }
            case "no-permission": {
                return "&cYou don't have permission to use this command.";
            }
            case "rtp-usage": {
                return "&cUsage: /rtp [player] [world]";
            }
            case "rtpo-usage": {
                return "&cUsage: /rtpo <player> [world]";
            }
            case "admin-usage": {
                return "&cUsage: /easyrtp reload";
            }
            case "player-not-found": {
                return "&cPlayer not found.";
            }
            case "world-not-found": {
                return "&cWorld not found.";
            }
            case "cannot-teleport-self": {
                return "&cYou cannot teleport yourself with /rtpo!";
            }
            case "cooldown": {
                return "&cYou must wait &e%time% &cseconds before using RTP again!";
            }
            case "teleport-starting": {
                return "&eStarting random teleport in &6%delay% &eseconds...";
            }
            case "teleport-success": {
                return "&aYou have been teleported to a random location!";
            }
            case "teleport-success-other": {
                return "&a%player% has been teleported to a random location!";
            }
            case "teleport-failed": {
                return "&cFailed to find a safe location! Please try again.";
            }
            case "teleport-cancelled": {
                return "&cRandom teleport cancelled!";
            }
            case "teleport-world-disabled": {
                return "&cRandom teleport is disabled in this world!";
            }
            case "teleport-other-starting": {
                return "&eTeleporting &6%player% &eto a random location...";
            }
            case "teleport-other-success": {
                return "&aYou have been teleported to a random location by &6%sender%&a!";
            }
            case "teleport-in-progress": {
                return "&cYou are already teleporting! Please wait for the current teleport to complete.";
            }
            case "teleport-location": {
                return "&7Location: &e%x%, %y%, %z% &7in &e%world%";
            }
            case "teleport-time": {
                return "&7Teleport took &e%time%ms";
            }
            case "insufficient-hunger": {
                return "&cYou need at least &6%hunger% &chunger points to use RTP!";
            }
            case "insufficient-xp": {
                return "&cYou need at least &6%xp% &cexperience levels to use RTP!";
            }
            case "cost-applied": {
                return "&7Cost: &6-%hunger% hunger &7and &6-%xp% XP levels";
            }
            case "title-teleporting": {
                return "&6&lTELEPORTING...";
            }
            case "subtitle-teleporting": {
                return "&7Finding safe location...";
            }
            case "title-success": {
                return "&a&lTELEPORTED!";
            }
            case "subtitle-success": {
                return "&7Welcome to your new location!";
            }
            case "title-cancelled": {
                return "&c&lTELEPORT CANCELLED!";
            }
            case "subtitle-cancelled": {
                return "&7You moved and your teleport was cancelled!";
            }
            case "config-reloading": {
                return "&eReloading EasyRTP configuration...";
            }
            case "config-reloaded": {
                return "&aConfiguration has been reloaded successfully!";
            }
        }
        return "&cMessage not found: " + path;
    }

    public String getMessage(String path) {
        return this.config.getString("messages." + path, this.getDefaultMessage(path));
    }

    public String getMessage(String path, Player player) {
        return this.getMessage(path);
    }

    public String getMessage(String path, String ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new IllegalArgumentException("Placeholders must be in pairs of key-value");
        }
        String message = this.getMessage(path);
        for (int i = 0; i < placeholders.length; i += 2) {
            message = message.replace("%" + placeholders[i] + "%", placeholders[i + 1]);
        }
        return message;
    }

    public String getMessage(String path, Player player, String ... placeholders) {
        return this.getMessage(path, placeholders);
    }

    public int getCooldown() {
        return this.config.getInt("settings.cooldown", 30);
    }

    public boolean getSoundsEnabled() {
        return this.config.getBoolean("settings.enable-sounds", true);
    }

    public int getTeleportDelay() {
        return this.config.getInt("settings.teleport-delay", 3);
    }

    public int getMaxAttempts() {
        return this.config.getInt("settings.max-attempts", 100);
    }

    public int getMinDistance() {
        return this.config.getInt("settings.min-distance", 1000);
    }

    public int getMaxDistance() {
        return this.config.getInt("settings.max-distance", 10000);
    }

    public int getCenterX() {
        return this.config.getInt("settings.center-x", 0);
    }

    public int getCenterZ() {
        return this.config.getInt("settings.center-z", 0);
    }

    public int getMinY() {
        return this.config.getInt("settings.min-y", 60);
    }

    public int getMaxY() {
        return this.config.getInt("settings.max-y", 120);
    }

    public boolean getSafeLocationCheck() {
        return this.config.getBoolean("settings.safe-location-check", true);
    }

    public boolean getRequireSkyVisibility() {
        return this.config.getBoolean("settings.require-sky-visibility", true);
    }

    public boolean isWorldBlacklisted(String worldName) {
        return this.config.getStringList("settings.world-blacklist").contains(worldName);
    }

    public boolean getPreloadChunks() {
        return this.config.getBoolean("settings.preload-chunks", true);
    }

    public int getPreloadRadius() {
        return this.config.getInt("settings.preload-radius", 2);
    }

    public int getHungerCost() {
        return this.config.getInt("settings.hunger-cost", 0);
    }

    public int getXpCost() {
        return this.config.getInt("settings.xp-cost", 0);
    }

    public boolean getRequireCosts() {
        return this.config.getBoolean("settings.require-costs", false);
    }

    public boolean getEnableTitles() {
        return this.config.getBoolean("settings.enable-titles", true);
    }

    public int getTitleFadeIn() {
        return this.config.getInt("settings.title-fade-in", 10);
    }

    public int getTitleStay() {
        return this.config.getInt("settings.title-stay", 40);
    }

    public int getTitleFadeOut() {
        return this.config.getInt("settings.title-fade-out", 10);
    }

    public int getBlindnessDuration() {
        return this.config.getInt("settings.blindness-duration", 1);
    }

    public boolean getEnableCancelTitle() {
        return this.config.getBoolean("settings.enable-cancel-title", true);
    }

    public boolean getEnableCancelSound() {
        return this.config.getBoolean("settings.enable-cancel-sound", true);
    }

    public String getCancelSound() {
        return this.config.getString("settings.cancel-sound", "BLOCK_NOTE_BLOCK_BASS");
    }

    public String getDefaultPrefix() {
        return "&7[&6EasyRTP&7] &r";
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

