/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.utils;

import com.maybeizen.EasyRTP.EasyRTP;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;

public class DatabaseManager {
    private final EasyRTP plugin;
    private Connection connection;
    private final String dbFile;

    public DatabaseManager(EasyRTP plugin) {
        this.plugin = plugin;
        this.dbFile = new File(plugin.getDataFolder(), "easyrtp.db").getAbsolutePath();
    }

    private void initialize() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbFile);
            this.plugin.getLogger().info("Database connection established successfully");
        }
        catch (ClassNotFoundException e) {
            this.plugin.getLogger().log(Level.SEVERE, "SQLite JDBC driver not found", e);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not connect to SQLite database", e);
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.plugin.getLogger().info("Database connection closed");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error closing database connection", e);
        }
    }

    public boolean isConnectionValid() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void reconnectIfNeeded() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.initialize();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error checking database connection", e);
            this.initialize();
        }
    }
}

