/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.utils;

import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class VersionAdapter {
    private static final String SERVER_VERSION;
    private static final boolean IS_LEGACY;

    public static void playRequestSound(Player player) {
        if (IS_LEGACY) {
            player.playSound(player.getLocation(), Sound.valueOf((String)"BLOCK_NOTE_BLOCK_PLING"), 1.0f, 1.0f);
        } else {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
        }
    }

    public static void playTeleportSound(Player player) {
        if (IS_LEGACY) {
            player.playSound(player.getLocation(), Sound.valueOf((String)"ENTITY_ENDERMAN_TELEPORT"), 1.0f, 1.0f);
        } else {
            player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        }
    }

    public static void playCancelSound(Player player, String soundName) {
        try {
            Sound sound = IS_LEGACY ? Sound.valueOf((String)soundName) : Sound.valueOf((String)soundName);
            player.playSound(player.getLocation(), sound, 1.0f, 0.5f);
        }
        catch (IllegalArgumentException e) {
            if (IS_LEGACY) {
                player.playSound(player.getLocation(), Sound.valueOf((String)"BLOCK_NOTE_BLOCK_BASS"), 1.0f, 0.5f);
            }
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
        }
    }

    public static String getServerVersion() {
        return SERVER_VERSION;
    }

    static {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        SERVER_VERSION = packageName.substring(packageName.lastIndexOf(46) + 1);
        IS_LEGACY = SERVER_VERSION.startsWith("v1_19");
    }
}

