/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.commands;

import com.maybeizen.EasyRTP.EasyRTP;
import com.maybeizen.EasyRTP.managers.RTPManager;
import com.maybeizen.EasyRTP.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RTPOCommand
implements CommandExecutor,
TabCompleter {
    private final EasyRTP plugin;
    private final RTPManager rtpManager;

    public RTPOCommand(EasyRTP plugin) {
        this.plugin = plugin;
        this.rtpManager = new RTPManager(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("easyrtp.rtpo")) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("no-permission")));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("rtpo-usage")));
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)args[0]);
        if (targetPlayer == null) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("player-not-found")));
            return true;
        }
        if (sender instanceof Player && targetPlayer.equals(sender)) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("cannot-teleport-self")));
            return true;
        }
        World targetWorld = targetPlayer.getWorld();
        if (args.length > 1) {
            World foundWorld = Bukkit.getWorld((String)args[1]);
            if (foundWorld != null) {
                targetWorld = foundWorld;
            } else {
                sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("world-not-found")));
                return true;
            }
        }
        if (!targetPlayer.hasPermission("easyrtp.cooldown.bypass") && this.plugin.getCooldownManager().hasCooldown(targetPlayer.getUniqueId())) {
            long timeLeft = this.plugin.getCooldownManager().getRemainingTime(targetPlayer.getUniqueId()) / 1000L;
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("cooldown", "time", String.valueOf(timeLeft))));
            return true;
        }
        if (!sender.hasPermission("easyrtp.world.bypass") && this.plugin.getConfigManager().isWorldBlacklisted(targetWorld.getName())) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("teleport-world-disabled")));
            return true;
        }
        if (!this.rtpManager.canAffordTeleport(targetPlayer)) {
            return true;
        }
        this.rtpManager.startRandomTeleportOther(sender, targetPlayer, targetWorld);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block3: {
            block2: {
                completions = new ArrayList<String>();
                if (args.length != 1) break block2;
                String partial = args[0].toLowerCase();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(partial)) continue;
                    completions.add(player.getName());
                }
                break block3;
            }
            if (args.length != 2) break block3;
            String partial = args[1].toLowerCase();
            for (World world : Bukkit.getWorlds()) {
                if (!world.getName().toLowerCase().startsWith(partial)) continue;
                completions.add(world.getName());
            }
        }
        return completions;
    }
}

