/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.managers;

import java.util.HashMap;
import java.util.UUID;

public class CooldownManager {
    private final HashMap<UUID, Long> cooldowns = new HashMap();
    private final long cooldownTime;

    public CooldownManager(long cooldownSeconds) {
        this.cooldownTime = cooldownSeconds * 1000L;
    }

    public boolean hasCooldown(UUID playerId) {
        if (!this.cooldowns.containsKey(playerId)) {
            return false;
        }
        long timeLeft = this.getRemainingTime(playerId);
        if (timeLeft <= 0L) {
            this.cooldowns.remove(playerId);
            return false;
        }
        return true;
    }

    public long getRemainingTime(UUID playerId) {
        return this.cooldowns.containsKey(playerId) ? this.cooldowns.get(playerId) - System.currentTimeMillis() : 0L;
    }

    public void setCooldown(UUID playerId) {
        this.cooldowns.put(playerId, System.currentTimeMillis() + this.cooldownTime);
    }

    public String getRemainingTimeString(UUID playerId) {
        long timeLeft = this.getRemainingTime(playerId) / 1000L;
        return timeLeft + " seconds";
    }
}

