/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.managers;

import com.maybeizen.EasyRTP.EasyRTP;
import com.maybeizen.EasyRTP.managers.TeleportExecutor;
import com.maybeizen.EasyRTP.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RTPManager {
    private final EasyRTP plugin;
    private final TeleportExecutor teleportExecutor;
    private final Map<UUID, BukkitRunnable> teleportTasks;

    public RTPManager(EasyRTP plugin) {
        this.plugin = plugin;
        this.teleportExecutor = new TeleportExecutor(plugin);
        this.teleportTasks = new HashMap<UUID, BukkitRunnable>();
    }

    public boolean canAffordTeleport(Player player) {
        return this.teleportExecutor.getCostManager().canAffordTeleport(player);
    }

    public void startRandomTeleport(Player player) {
        this.startRandomTeleport(player, player.getWorld());
    }

    public void startRandomTeleport(final Player player, final World world) {
        final UUID playerId = player.getUniqueId();
        if (this.teleportTasks.containsKey(playerId)) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("teleport-in-progress")));
            return;
        }
        int delay = this.plugin.getConfigManager().getTeleportDelay();
        this.teleportExecutor.getTitleManager().showTeleportingTitle(player);
        if (delay <= 0) {
            this.teleportExecutor.executeTeleport(player, world);
        } else {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("teleport-starting", "delay", String.valueOf(delay))));
            BukkitRunnable task = new BukkitRunnable(){

                public void run() {
                    if (player.isOnline()) {
                        RTPManager.this.teleportExecutor.executeTeleport(player, world);
                    }
                    RTPManager.this.teleportTasks.remove(playerId);
                }
            };
            task.runTaskLater((Plugin)this.plugin, (long)delay * 20L);
            this.teleportTasks.put(playerId, task);
        }
    }

    public void startRandomTeleportOther(final CommandSender sender, final Player targetPlayer, final World world) {
        final UUID playerId = targetPlayer.getUniqueId();
        if (this.teleportTasks.containsKey(playerId)) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("teleport-in-progress")));
            return;
        }
        int delay = this.plugin.getConfigManager().getTeleportDelay();
        sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("teleport-other-starting", "player", targetPlayer.getName())));
        if (delay <= 0) {
            this.teleportExecutor.executeTeleportOther(sender, targetPlayer, world);
        } else {
            BukkitRunnable task = new BukkitRunnable(){

                public void run() {
                    if (targetPlayer.isOnline()) {
                        RTPManager.this.teleportExecutor.executeTeleportOther(sender, targetPlayer, world);
                    }
                    RTPManager.this.teleportTasks.remove(playerId);
                }
            };
            task.runTaskLater((Plugin)this.plugin, (long)delay * 20L);
            this.teleportTasks.put(playerId, task);
        }
    }

    public void cancelTeleportTask(UUID playerId) {
        BukkitRunnable task = this.teleportTasks.get(playerId);
        if (task != null) {
            task.cancel();
            this.teleportTasks.remove(playerId);
        }
    }

    public void cancelAllTeleportTasks() {
        for (BukkitRunnable task : this.teleportTasks.values()) {
            task.cancel();
        }
        this.teleportTasks.clear();
    }
}

