/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.utils;

import com.maybeizen.EasyRTP.EasyRTP;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ConfigManager {
    private static ConfigManager instance;
    private final EasyRTP plugin;
    private FileConfiguration config;

    private ConfigManager(EasyRTP plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public static ConfigManager getInstance(EasyRTP plugin) {
        if (instance == null) {
            instance = new ConfigManager(plugin);
        } else {
            instance.loadConfig();
        }
        return instance;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getMessage(String path) {
        return this.config.getString("messages." + path, "Message not found: " + path);
    }

    public String getMessage(String path, Player player) {
        return this.getMessage(path);
    }

    public String getMessage(String path, String ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new IllegalArgumentException("Placeholders must be in pairs of key-value");
        }
        String message = this.getMessage(path);
        for (int i = 0; i < placeholders.length; i += 2) {
            message = message.replace("%" + placeholders[i] + "%", placeholders[i + 1]);
        }
        return message;
    }

    public String getMessage(String path, Player player, String ... placeholders) {
        return this.getMessage(path, placeholders);
    }

    public int getCooldown() {
        return this.config.getInt("settings.cooldown", 30);
    }

    public boolean getSoundsEnabled() {
        return this.config.getBoolean("settings.enable-sounds", true);
    }

    public int getTeleportDelay() {
        return this.config.getInt("settings.teleport-delay", 3);
    }

    public int getMaxAttempts() {
        return this.config.getInt("settings.max-attempts", 100);
    }

    public int getMinDistance() {
        return this.config.getInt("settings.min-distance", 1000);
    }

    public int getMaxDistance() {
        return this.config.getInt("settings.max-distance", 10000);
    }

    public int getCenterX() {
        return this.config.getInt("settings.center-x", 0);
    }

    public int getCenterZ() {
        return this.config.getInt("settings.center-z", 0);
    }

    public int getMinY() {
        return this.config.getInt("settings.min-y", 60);
    }

    public int getMaxY() {
        return this.config.getInt("settings.max-y", 120);
    }

    public boolean getSafeLocationCheck() {
        return this.config.getBoolean("settings.safe-location-check", true);
    }

    public boolean isWorldBlacklisted(String worldName) {
        return this.config.getStringList("settings.world-blacklist").contains(worldName);
    }

    public boolean getPreloadChunks() {
        return this.config.getBoolean("settings.preload-chunks", true);
    }

    public int getPreloadRadius() {
        return this.config.getInt("settings.preload-radius", 2);
    }

    public int getHungerCost() {
        return this.config.getInt("settings.hunger-cost", 0);
    }

    public int getXpCost() {
        return this.config.getInt("settings.xp-cost", 0);
    }

    public boolean getRequireCosts() {
        return this.config.getBoolean("settings.require-costs", false);
    }

    public boolean getEnableTitles() {
        return this.config.getBoolean("settings.enable-titles", true);
    }

    public int getTitleFadeIn() {
        return this.config.getInt("settings.title-fade-in", 10);
    }

    public int getTitleStay() {
        return this.config.getInt("settings.title-stay", 40);
    }

    public int getTitleFadeOut() {
        return this.config.getInt("settings.title-fade-out", 10);
    }

    public int getBlindnessDuration() {
        return this.config.getInt("settings.blindness-duration", 1);
    }

    public String getDefaultPrefix() {
        return "&7[&6EasyRTP&7] &r";
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

