/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyRTP.utils;

import com.maybeizen.EasyRTP.EasyRTP;
import com.maybeizen.EasyRTP.utils.VersionAdapter;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;

public class MessageUtils {
    private static EasyRTP plugin;
    private static final LegacyComponentSerializer LEGACY_SERIALIZER;
    private static final MiniMessage MINI_MESSAGE;

    public static void initialize(EasyRTP pluginInstance) {
        plugin = pluginInstance;
    }

    private static Component getPrefix() {
        String prefix = plugin.getConfigManager().getMessage("prefix");
        if (prefix.equals("Message not found: prefix")) {
            prefix = plugin.getConfigManager().getDefaultPrefix();
        }
        return MessageUtils.parseText(prefix);
    }

    public static Component parseText(String message) {
        if (message.contains("<") && message.contains(">")) {
            return MINI_MESSAGE.deserialize((Object)message);
        }
        return LEGACY_SERIALIZER.deserialize(message);
    }

    public static Component formatMessage(String message) {
        return MessageUtils.getPrefix().append(MessageUtils.parseText(message));
    }

    public static Component formatMessage(String message, Player player) {
        return MessageUtils.getPrefix().append(MessageUtils.parseText(message));
    }

    public static Component formatMessage(String message, String ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new IllegalArgumentException("Placeholders must be in pairs of key-value");
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (int i = 0; i < placeholders.length; i += 2) {
            replacements.put(placeholders[i], placeholders[i + 1]);
        }
        String formattedMessage = message;
        for (Map.Entry entry : replacements.entrySet()) {
            formattedMessage = formattedMessage.replace("%" + (String)entry.getKey() + "%", (CharSequence)entry.getValue());
        }
        return MessageUtils.getPrefix().append(MessageUtils.parseText(formattedMessage));
    }

    public static Component formatMessage(String message, Player player, String ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new IllegalArgumentException("Placeholders must be in pairs of key-value");
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (int i = 0; i < placeholders.length; i += 2) {
            replacements.put(placeholders[i], placeholders[i + 1]);
        }
        String formattedMessage = message;
        for (Map.Entry entry : replacements.entrySet()) {
            formattedMessage = formattedMessage.replace("%" + (String)entry.getKey() + "%", (CharSequence)entry.getValue());
        }
        return MessageUtils.getPrefix().append(MessageUtils.parseText(formattedMessage));
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage(MessageUtils.formatMessage(message, player));
    }

    public static void sendMessage(Player player, String message, String ... placeholders) {
        player.sendMessage(MessageUtils.formatMessage(message, player, placeholders));
    }

    public static void playTeleportEffect(Player player) {
        if (plugin != null && plugin.getConfigManager().getSoundsEnabled()) {
            VersionAdapter.playTeleportSound(player);
        }
    }

    static {
        LEGACY_SERIALIZER = LegacyComponentSerializer.builder().character('&').hexColors().build();
        MINI_MESSAGE = MiniMessage.miniMessage();
    }
}

