/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.event.claims.ClaimProtectionChangeEvent;
import net.mathias2246.buildmc.api.event.claims.ClaimWhitelistChangeEvent;
import net.mathias2246.buildmc.claims.ClaimLogger;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.claims.ClaimToolItemMetaModifier;
import net.mathias2246.buildmc.claims.tools.ClaimSelectionTool;
import net.mathias2246.buildmc.commandAPI.CommandAPICommand;
import net.mathias2246.buildmc.commandAPI.arguments.Argument;
import net.mathias2246.buildmc.commandAPI.arguments.NamespacedKeyArgument;
import net.mathias2246.buildmc.commandAPI.arguments.StringArgument;
import net.mathias2246.buildmc.commandAPI.executors.ExecutorType;
import net.mathias2246.buildmc.commands.CustomCommand;
import net.mathias2246.buildmc.ui.claims.ClaimSelectMenu;
import net.mathias2246.buildmc.util.CommandUtil;
import net.mathias2246.buildmc.util.LocationUtil;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Team;

public class ClaimCommand
implements CustomCommand {
    @Override
    public CommandAPICommand getCommand() {
        ClaimToolItemMetaModifier modifier = new ClaimToolItemMetaModifier();
        ClaimSelectionTool claimTool = (ClaimSelectionTool)Objects.requireNonNull(Main.customItems.get(NamespacedKey.fromString((String)"buildmc:claim_tool")));
        boolean isClaimtoolGiveEnabled = Main.config.getBoolean("claims.tool.enable-give-command", true);
        return ((CommandAPICommand)new CommandAPICommand("claim").executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer(command);
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = patt0$temp;
            ClaimSelectMenu.open(player);
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("claimtool").withRequirement(cmd -> isClaimtoolGiveEnabled)).executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer(command);
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = patt0$temp;
            if (player.getInventory().firstEmpty() == -1) {
                Main.audiences.sender((CommandSender)player).sendMessage(Message.msg(player, "messages.claims.tool.full-inventory"));
                return;
            }
            claimTool.giveToPlayer(player, modifier);
            Main.audiences.sender((CommandSender)player).sendMessage(Message.msg(player, "messages.claims.tool.give-success"));
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)new CommandAPICommand("edit").executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer(command);
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = patt0$temp;
            ClaimSelectMenu.open(player);
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)new CommandAPICommand("who").executes(command -> {
            Claim claim;
            Player patt0$temp = CommandUtil.requiresPlayer(command);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            try {
                claim = ClaimManager.getClaim(player.getLocation());
            }
            catch (SQLException e) {
                CoreMain.plugin.getLogger().severe("An error occurred while getting a claim from the database: " + e.getMessage());
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.sql"));
                return 0;
            }
            if (claim == null) {
                Main.audiences.sender((CommandSender)command.sender()).sendMessage(Component.translatable("messages.claims.who.unclaimed"));
                return 1;
            }
            ClaimType claimType = claim.getType();
            if (claimType == ClaimType.TEAM) {
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.who.team-message", Map.of("owner", claim.getOwnerId())));
            } else if (claimType == ClaimType.PLAYER) {
                UUID ownerId = UUID.fromString(claim.getOwnerId());
                OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)ownerId);
                String ownerName = owner.getName();
                if (ownerName == null) {
                    ownerName = "Unknown";
                }
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.who.player-message", Map.of("owner", ownerName)));
            } else if (claimType == ClaimType.SERVER || claimType == ClaimType.PLACEHOLDER) {
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.who.server-message"));
            }
            return 1;
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)new CommandAPICommand("help").executes(command -> {
            CommandSender sender = (CommandSender)command.sender();
            Main.audiences.sender(sender).sendMessage(Component.translatable("messages.claims.help-message"));
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withArguments(new Argument[]{(Argument)new StringArgument("type").replaceSuggestions((info, builder) -> {
            Player player;
            builder.suggest("player").suggest("team");
            Object patt0$temp = info.sender();
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("buildmc.admin")) {
                builder.suggest("server").suggest("placeholder");
            }
            return builder.buildFuture();
        })})).withArguments(new Argument[]{new StringArgument("name")})).executes(command -> {
            List<Claim> overlappingClaims;
            Player patt0$temp = CommandUtil.requiresPlayer(command);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = command.args().getByClass("type", String.class);
            String name = command.args().getByClass("name", String.class);
            if (type == null || name == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.invalid-args"));
                return 0;
            }
            if (!player.hasMetadata(claimTool.firstSelectionKey) || !player.hasMetadata(claimTool.secondSelectionKey)) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.missing-positions"));
                return 0;
            }
            Location pos1 = claimTool.getFirstSelection(player);
            Location pos2 = claimTool.getSecondSelection(player);
            if (pos1 == null || pos2 == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.missing-positions"));
                return 0;
            }
            if (!Objects.equals(pos1.getWorld(), pos2.getWorld())) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.different-worlds"));
                return 0;
            }
            try {
                overlappingClaims = ClaimManager.getClaimsInArea(pos1, pos2);
            }
            catch (SQLException e) {
                CoreMain.plugin.getLogger().severe("Error while checking claim overlaps: " + String.valueOf(e));
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.error-database"));
                return 0;
            }
            if (!overlappingClaims.isEmpty()) {
                boolean serverProtected = overlappingClaims.stream().anyMatch(claim -> claim.getType() == ClaimType.SERVER);
                if (serverProtected) {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.protected-server"));
                } else {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.overlap"));
                }
                return 0;
            }
            int newClaimChunks = LocationUtil.calculateChunkArea(pos1, pos2);
            switch (type.toLowerCase()) {
                case "player": {
                    int maxChunksAllowed = CoreMain.plugin.getConfig().getInt("claims.player-max-chunk-claim-amount");
                    int remainingChunks = ClaimManager.playerRemainingClaims.getOrDefault(player.getUniqueId().toString(), maxChunksAllowed);
                    if (remainingChunks - newClaimChunks < 0) {
                        Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.create.no-remaining-claims", Map.of("no-remaining-claims", String.valueOf(remainingChunks))));
                        return 0;
                    }
                    try {
                        if (ClaimManager.doesOwnerHaveClaimWithName(player.getUniqueId().toString(), name)) {
                            Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.duplicate-name"));
                            return 1;
                        }
                    }
                    catch (SQLException e) {
                        CoreMain.plugin.getLogger().severe("SQL Error while trying to check claim name availability: " + String.valueOf(e));
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.error-database"));
                        return 0;
                    }
                    boolean success = ClaimManager.tryClaimPlayerArea(player, name, pos1, pos2);
                    if (success) {
                        Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.create.success", Map.of("remaining_claims", String.valueOf(remainingChunks - newClaimChunks))));
                        player.removeMetadata(claimTool.firstSelectionKey, claimTool.getPlugin());
                        player.removeMetadata(claimTool.secondSelectionKey, claimTool.getPlugin());
                        ClaimLogger.logClaimCreated(player, name);
                        return 1;
                    }
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.failed"));
                    return 0;
                }
                case "team": {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.error.not-in-a-team"));
                        return 0;
                    }
                    int maxChunksAllowed = CoreMain.plugin.getConfig().getInt("claims.team-max-chunk-claim-amount");
                    int remainingChunks = ClaimManager.teamRemainingClaims.getOrDefault(team.getName(), maxChunksAllowed);
                    if (remainingChunks - newClaimChunks < 0) {
                        Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.create.no-remaining-claims", Map.of("remaining_claims", String.valueOf(remainingChunks))));
                        return 0;
                    }
                    try {
                        if (ClaimManager.doesOwnerHaveClaimWithName(team.getName(), name)) {
                            Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.duplicate-name"));
                            return 1;
                        }
                    }
                    catch (SQLException e) {
                        CoreMain.plugin.getLogger().severe("SQL Error while trying to check claim name availability: " + String.valueOf(e));
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.error-database"));
                        return 0;
                    }
                    boolean success = ClaimManager.tryClaimTeamArea(team, name, pos1, pos2);
                    if (success) {
                        Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.create.success", Map.of("remaining_claims", String.valueOf(remainingChunks - newClaimChunks))));
                        player.removeMetadata(claimTool.firstSelectionKey, claimTool.getPlugin());
                        player.removeMetadata(claimTool.secondSelectionKey, claimTool.getPlugin());
                        ClaimLogger.logClaimCreated(player, name);
                        return 1;
                    }
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.failed"));
                    return 0;
                }
                case "server": 
                case "placeholder": {
                    boolean success;
                    if (!player.hasPermission("buildmc.admin")) {
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.error.no-permission"));
                        return 0;
                    }
                    try {
                        if (ClaimManager.doesOwnerHaveClaimWithName(type.toLowerCase(), name)) {
                            Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.duplicate-name"));
                            return 1;
                        }
                    }
                    catch (SQLException e) {
                        CoreMain.plugin.getLogger().severe("SQL Error while trying to check claim name availability: " + String.valueOf(e));
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.error-database"));
                        return 0;
                    }
                    switch (type.toLowerCase()) {
                        case "server": {
                            boolean bl = ClaimManager.tryClaimServerArea(name, pos1, pos2);
                            break;
                        }
                        case "placeholder": {
                            boolean bl = ClaimManager.tryClaimPlaceholderArea(name, pos1, pos2);
                            break;
                        }
                        default: {
                            boolean bl = success = false;
                        }
                    }
                    if (success) {
                        Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.create.success-" + type.toLowerCase(), Map.of("claim_name", name)));
                        player.removeMetadata(claimTool.firstSelectionKey, claimTool.getPlugin());
                        player.removeMetadata(claimTool.secondSelectionKey, claimTool.getPlugin());
                        ClaimLogger.logClaimCreated(player, name);
                        return 1;
                    }
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.failed"));
                    return 0;
                }
            }
            Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.invalid-type"));
            return 0;
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("remove").withArguments(new Argument[]{(Argument)new StringArgument("type").replaceSuggestions((info, builder) -> {
            Player player;
            builder.suggest("player").suggest("team");
            Object patt0$temp = info.sender();
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("buildmc.admin")) {
                builder.suggest("server").suggest("placeholder");
            }
            return builder.buildFuture();
        }), (Argument)new StringArgument("claim").replaceSuggestions((info, builder) -> {
            Object patt0$temp = info.sender();
            if (!(patt0$temp instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)patt0$temp;
            String type = info.previousArgs().getOrDefault("type", (Object)"").toString().toLowerCase();
            List<Long> claimIds = switch (type) {
                case "player" -> ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                case "team" -> {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        yield List.of();
                    }
                    yield ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
                case "server" -> {
                    if (player.hasPermission("buildmc.admin")) {
                        yield ClaimManager.serverClaims;
                    }
                    yield List.of();
                }
                case "placeholder" -> {
                    if (player.hasPermission("buildmc.admin")) {
                        yield ClaimManager.placeholderClaims;
                    }
                    yield List.of();
                }
                default -> List.of();
            };
            for (Long id : claimIds) {
                String name = ClaimManager.getClaimNameById(id);
                if (name == null || !name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(name);
            }
            return builder.buildFuture();
        })})).executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer(command);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = command.args().getByClass("type", String.class);
            String claimName = command.args().getByClass("claim", String.class);
            if (type == null || claimName == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.invalid-args"));
                return 0;
            }
            long claimId = -1L;
            block6 : switch (type.toLowerCase()) {
                case "player": {
                    List ids = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                    Iterator iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        String name = ClaimManager.getClaimNameById(id);
                        if (name == null || !name.equalsIgnoreCase(claimName)) continue;
                        claimId = id;
                        break block6;
                    }
                    break;
                }
                case "team": {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.error.not-in-a-team"));
                        return 0;
                    }
                    List ids = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                    Iterator id = ids.iterator();
                    while (id.hasNext()) {
                        long id2 = (Long)id.next();
                        String name = ClaimManager.getClaimNameById(id2);
                        if (name == null || !name.equalsIgnoreCase(claimName)) continue;
                        claimId = id2;
                        break block6;
                    }
                    break;
                }
                case "server": 
                case "placeholder": {
                    if (!player.hasPermission("buildmc.admin")) {
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.error.no-permission"));
                        return 0;
                    }
                    List<Long> ids = type.equals("server") ? ClaimManager.serverClaims : ClaimManager.placeholderClaims;
                    for (long id : ids) {
                        String name = ClaimManager.getClaimNameById(id);
                        if (name == null || !name.equalsIgnoreCase(claimName)) continue;
                        claimId = id;
                        break block6;
                    }
                    break;
                }
                default: {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.remove.invalid-type"));
                    return 0;
                }
            }
            if (claimId == -1L) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.remove.not-found"));
                return 0;
            }
            boolean success = ClaimManager.removeClaimById(claimId);
            if (success) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.remove.success"));
                ClaimLogger.logClaimDeleted(player, claimName);
                return 1;
            }
            Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.remove.failed"));
            return 0;
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("whitelist").withArguments(new Argument[]{(Argument)new StringArgument("action").replaceSuggestions((info, builder) -> builder.suggest("add").suggest("remove").buildFuture()), (Argument)new StringArgument("type").replaceSuggestions((info, builder) -> {
            Player player;
            builder.suggest("player").suggest("team");
            Object patt0$temp = info.sender();
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("buildmc.admin")) {
                builder.suggest("server");
            }
            return builder.buildFuture();
        }), (Argument)new StringArgument("claim").replaceSuggestions((info, builder) -> {
            Object patt0$temp = info.sender();
            if (!(patt0$temp instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)patt0$temp;
            String type = info.previousArgs().getOrDefault("type", (Object)"").toString().toLowerCase();
            List<Long> claimIds = switch (type) {
                case "player" -> ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                case "team" -> {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        yield List.of();
                    }
                    yield ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
                case "server" -> {
                    if (player.hasPermission("buildmc.admin")) {
                        yield ClaimManager.serverClaims;
                    }
                    yield List.of();
                }
                default -> List.of();
            };
            for (Long claimId : claimIds) {
                String name = ClaimManager.getClaimNameById(claimId);
                if (name == null) continue;
                builder.suggest(name);
            }
            return builder.buildFuture();
        }), (Argument)new StringArgument("targetPlayer").replaceSuggestions((info, builder) -> {
            CommandSender sender = (CommandSender)info.sender();
            if (!(sender instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)sender;
            List<String> inputArgs = List.of(info.currentInput().split(" "));
            if (inputArgs.size() < 4) {
                return builder.buildFuture();
            }
            String type = inputArgs.get(2);
            String claimName = inputArgs.get(3);
            List<Long> claimIds = switch (type.toLowerCase()) {
                case "player" -> ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                case "team" -> {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        yield List.of();
                    }
                    yield ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
                case "server" -> {
                    if (player.hasPermission("buildmc.admin")) {
                        yield ClaimManager.serverClaims;
                    }
                    yield List.of();
                }
                default -> List.of();
            };
            for (Long claimId : claimIds) {
                Claim claim;
                String name = ClaimManager.getClaimNameById(claimId);
                if (name == null || !name.equalsIgnoreCase(claimName) || (claim = ClaimManager.getClaimByID(claimId)) == null) continue;
                List<UUID> whitelisted = claim.getWhitelistedPlayers();
                Team team = ClaimManager.getPlayerTeam(player);
                Bukkit.getOnlinePlayers().stream().filter(p -> claim.getType().equals((Object)ClaimType.SERVER) || !p.getUniqueId().equals(player.getUniqueId())).filter(p -> team == null || !team.hasEntry(p.getName())).filter(p -> !whitelisted.contains(p.getUniqueId())).map(Player::getName).forEach(builder::suggest);
                break;
            }
            return builder.buildFuture();
        })})).executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer(command);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String action = command.args().getByClass("action", String.class);
            String type = command.args().getByClass("type", String.class);
            String claimName = command.args().getByClass("claim", String.class);
            String targetPlayerName = command.args().getByClass("targetPlayer", String.class);
            if (action == null || type == null || claimName == null || targetPlayerName == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.invalid-args"));
                return 0;
            }
            List<Long> claimIds = switch (type.toLowerCase()) {
                case "player" -> ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                case "team" -> {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.error.not-in-a-team"));
                        yield List.of();
                    }
                    yield ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
                case "server" -> {
                    if (player.hasPermission("buildmc.admin")) {
                        yield ClaimManager.serverClaims;
                    }
                    yield List.of();
                }
                default -> {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.create.invalid-type"));
                    yield List.of();
                }
            };
            Long claimId = claimIds.stream().filter(id -> claimName.equalsIgnoreCase(ClaimManager.getClaimNameById(id))).findFirst().orElse(null);
            if (claimId == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.whitelist.claim-not-found"));
                return 0;
            }
            Player target = Bukkit.getPlayerExact((String)targetPlayerName);
            if (target == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.whitelist.player-not-found"));
                return 0;
            }
            UUID targetUUID = target.getUniqueId();
            Claim claim = ClaimManager.getClaimByID(claimId);
            if (claim == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.whitelist.claim-not-found"));
                return 0;
            }
            switch (action.toLowerCase()) {
                case "add": {
                    if (claim.getWhitelistedPlayers().contains(targetUUID)) {
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.whitelist.already-added"));
                        return 0;
                    }
                    ClaimWhitelistChangeEvent event = new ClaimWhitelistChangeEvent(claim, (OfflinePlayer)target, (CommandSender)command.sender(), ClaimWhitelistChangeEvent.ChangeAction.ADDED);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return 0;
                    }
                    ClaimManager.addPlayerToWhitelist(claimId, targetUUID);
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.whitelist.added"));
                    ClaimLogger.logWhitelistAdded(player, claimName, targetPlayerName, targetUUID.toString());
                    return 1;
                }
                case "remove": {
                    if (!claim.getWhitelistedPlayers().contains(targetUUID)) {
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.whitelist.not-on-list"));
                        return 0;
                    }
                    ClaimWhitelistChangeEvent event = new ClaimWhitelistChangeEvent(claim, (OfflinePlayer)target, (CommandSender)command.sender(), ClaimWhitelistChangeEvent.ChangeAction.REMOVED);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return 0;
                    }
                    ClaimManager.removePlayerFromWhitelist(claimId, targetUUID);
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.whitelist.removed"));
                    ClaimLogger.logWhitelistRemoved(player, claimName, targetPlayerName, targetUUID.toString());
                    return 1;
                }
            }
            Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.whitelist.invalid-action"));
            return 0;
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("protections").withArguments(new Argument[]{(Argument)new StringArgument("type").replaceSuggestions((info, builder) -> {
            Player player;
            builder.suggest("player").suggest("team");
            Object patt0$temp = info.sender();
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("buildmc.admin")) {
                builder.suggest("server");
            }
            return builder.buildFuture();
        }), (Argument)new StringArgument("claim").replaceSuggestions((info, builder) -> {
            List<Object> claimIds;
            Object patt0$temp = info.sender();
            if (!(patt0$temp instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)patt0$temp;
            String type = info.previousArgs().getOrDefault("type", (Object)"").toString().toLowerCase();
            switch (type) {
                case "player": {
                    claimIds = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                    break;
                }
                case "team": {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        return builder.buildFuture();
                    }
                    claimIds = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                    break;
                }
                case "server": {
                    if (!player.hasPermission("buildmc.admin")) {
                        return builder.buildFuture();
                    }
                    claimIds = ClaimManager.serverClaims;
                    break;
                }
                default: {
                    claimIds = List.of();
                }
            }
            for (Long claimId : claimIds) {
                String name = ClaimManager.getClaimNameById(claimId);
                if (name == null || !name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(name);
            }
            return builder.buildFuture();
        }), (Argument)new NamespacedKeyArgument("flag").replaceSuggestions((info, builder) -> {
            String remaining = builder.getRemaining();
            Iterator<Protection> iterator = CoreMain.protectionsRegistry.iterator();
            while (iterator.hasNext()) {
                Protection flag = iterator.next();
                String s = flag.getKey().toString();
                if (flag.isHidden() || !s.startsWith(remaining.toLowerCase())) continue;
                builder.suggest(s);
            }
            return builder.buildFuture();
        }), (Argument)new StringArgument("value").replaceSuggestions((info, builder) -> builder.suggest("true").suggest("false").buildFuture())})).executes(command -> {
            boolean enable;
            List<Long> claimIds;
            Player patt0$temp = CommandUtil.requiresPlayer(command);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = command.args().getByClass("type", String.class);
            String claimName = command.args().getByClass("claim", String.class);
            NamespacedKey flag = command.args().getByClass("flag", NamespacedKey.class);
            String value = command.args().getByClass("value", String.class);
            if (type == null || claimName == null || flag == null || value == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.invalid-args"));
                return 0;
            }
            type = type.toLowerCase();
            value = value.toLowerCase();
            if (Protection.isHiddenProtection(CoreMain.protectionsRegistry, flag)) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.protections.invalid-flag"));
                return 0;
            }
            switch (type) {
                case "player": {
                    List<Long> list = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                    break;
                }
                case "team": {
                    List<Long> list;
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.error.not-in-a-team"));
                        list = List.of();
                        break;
                    }
                    list = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                    break;
                }
                case "server": {
                    List<Long> list;
                    if (!player.hasPermission("buildmc.admin")) {
                        Main.audiences.player(player).sendMessage(Component.translatable("messages.error.no-permission"));
                        list = List.of();
                        break;
                    }
                    list = ClaimManager.serverClaims;
                    break;
                }
                default: {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.protections.invalid-type"));
                    List<Long> list = claimIds = List.of();
                }
            }
            if (claimIds.isEmpty()) {
                return 0;
            }
            Long claimId = claimIds.stream().filter(id -> {
                String name = ClaimManager.getClaimNameById(id);
                return name != null && name.equalsIgnoreCase(claimName);
            }).findFirst().orElse(null);
            if (claimId == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.protections.not-found"));
                return 0;
            }
            if (value.equals("true")) {
                enable = true;
            } else if (value.equals("false")) {
                enable = false;
            } else {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.protections.invalid-value"));
                return 0;
            }
            Claim claim = ClaimManager.getClaimByID(claimId);
            if (claim == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.protections.not-found"));
                return 0;
            }
            Protection protection = CoreMain.protectionLookup.get(flag);
            if (enable) {
                ClaimProtectionChangeEvent event = new ClaimProtectionChangeEvent(claim, protection, ClaimProtectionChangeEvent.ActiveState.ENABLED, (CommandSender)command.sender());
                if (event.isCancelled()) {
                    return 0;
                }
                ClaimManager.addProtection((long)claimId, flag);
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.protections.added").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%flag%").replacement(flag.toString()).build()));
                ClaimLogger.logProtectionChanged(player, claimName, flag.toString(), "enabled");
            } else {
                ClaimProtectionChangeEvent event = new ClaimProtectionChangeEvent(claim, protection, ClaimProtectionChangeEvent.ActiveState.DISABLED, (CommandSender)command.sender());
                if (event.isCancelled()) {
                    return 0;
                }
                ClaimManager.removeProtection((long)claimId, flag);
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.protections.removed").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%flag%").replacement(flag.toString()).build()));
                ClaimLogger.logProtectionChanged(player, claimName, flag.toString(), "disabled");
            }
            return 1;
        }, new ExecutorType[0]));
    }
}

