/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.protections.misc;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.item.ItemUtil;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.gui.type.util.Gui;
import net.mathias2246.buildmc.ui.UIUtil;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockReceiveGameEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SculkSensors
extends Protection {
    public SculkSensors(@Nullable ConfigurationSection section) {
        super(Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:sculk_sensors")), section != null ? section.getBoolean("default", true) : true, section != null && section.getBoolean("is-hidden", false));
    }

    @Override
    public String getTranslationBaseKey() {
        return "claims.flags.sculk-sensor";
    }

    @Override
    @NotNull
    public GuiItem getDisplay(@NotNull Player uiHolder, @NotNull Gui gui) {
        String t = this.getTranslationBaseKey();
        ItemStack displayBase = new ItemStack(Material.SCULK_SENSOR);
        ItemUtil.editMeta(displayBase, meta -> {
            meta.setItemName(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".name")));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setLore(List.of(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".lore")).split("\n")));
        });
        return new GuiItem(displayBase, UIUtil.noInteract);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSculkSensorTrigger(BlockReceiveGameEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        Block block = event.getBlock();
        if (entity == null) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!ClaimManager.isPlayerAllowed(player, this.getKey(), block.getLocation())) {
            event.setCancelled(true);
        }
    }
}

