/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.commandAPI.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.CompletableFuture;
import net.mathias2246.buildmc.commandAPI.CommandAPIBukkit;
import net.mathias2246.buildmc.commandAPI.arguments.CommandAPIArgumentType;
import net.mathias2246.buildmc.commandAPI.arguments.SafeOverrideableArgument;
import net.mathias2246.buildmc.commandAPI.executors.CommandArguments;
import org.bukkit.OfflinePlayer;

public class AsyncOfflinePlayerArgument
extends SafeOverrideableArgument<CompletableFuture<OfflinePlayer>, OfflinePlayer> {
    public AsyncOfflinePlayerArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentProfile(), OfflinePlayer::getName);
    }

    @Override
    public Class<CompletableFuture<OfflinePlayer>> getPrimitiveType() {
        return CompletableFuture.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ASYNC_OFFLINE_PLAYER;
    }

    @Override
    public <CommandSourceStack> CompletableFuture<OfflinePlayer> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CommandAPIBukkit.get().getOfflinePlayer(cmdCtx, key);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

