/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.commandAPI.arguments;

import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.mathias2246.buildmc.commandAPI.arguments.CommandAPIArgumentType;
import net.mathias2246.buildmc.commandAPI.arguments.SafeOverrideableArgument;
import net.mathias2246.buildmc.commandAPI.exceptions.InvalidRangeException;
import net.mathias2246.buildmc.commandAPI.executors.CommandArguments;

public class FloatArgument
extends SafeOverrideableArgument<Float, Float> {
    public FloatArgument(String nodeName) {
        super(nodeName, FloatArgumentType.floatArg(), String::valueOf);
    }

    public FloatArgument(String nodeName, float min) {
        super(nodeName, FloatArgumentType.floatArg(min), String::valueOf);
    }

    public FloatArgument(String nodeName, float min, float max) {
        super(nodeName, FloatArgumentType.floatArg(min, max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Float> getPrimitiveType() {
        return Float.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_FLOAT;
    }

    @Override
    public <Source> Float parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

