/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.commandAPI.arguments;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.mathias2246.buildmc.commandAPI.arguments.CommandAPIArgumentType;
import net.mathias2246.buildmc.commandAPI.arguments.SafeOverrideableArgument;
import net.mathias2246.buildmc.commandAPI.exceptions.InvalidRangeException;
import net.mathias2246.buildmc.commandAPI.executors.CommandArguments;

public class IntegerArgument
extends SafeOverrideableArgument<Integer, Integer> {
    public IntegerArgument(String nodeName) {
        super(nodeName, IntegerArgumentType.integer(), String::valueOf);
    }

    public IntegerArgument(String nodeName, int min) {
        super(nodeName, IntegerArgumentType.integer(min), String::valueOf);
    }

    public IntegerArgument(String nodeName, int min, int max) {
        super(nodeName, IntegerArgumentType.integer(min, max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Integer> getPrimitiveType() {
        return Integer.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_INTEGER;
    }

    @Override
    public <Source> Integer parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

