/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.commandAPI.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mathias2246.buildmc.commandAPI.network.CommandAPIPacket;
import net.mathias2246.buildmc.commandAPI.network.FriendlyByteBuffer;
import net.mathias2246.buildmc.commandAPI.network.packets.ProtocolVersionTooOldPacket;
import net.mathias2246.buildmc.commandAPI.network.packets.SetVersionPacket;
import net.mathias2246.buildmc.commandAPI.network.packets.UpdateRequirementsPacket;

public enum CommandAPIProtocol {
    HANDSHAKE("commandapi:handshake", new PacketSetBuilder().register(SetVersionPacket.class, SetVersionPacket::deserialize).register(ProtocolVersionTooOldPacket.class, ProtocolVersionTooOldPacket::deserialize)),
    PLAY("commandapi:play", new PacketSetBuilder().register(UpdateRequirementsPacket.class, UpdateRequirementsPacket::deserialize));

    public static final int PROTOCOL_VERSION = 1;
    private static final Map<String, CommandAPIProtocol> channelIdentifierToProtocol;
    private static final Map<Class<? extends CommandAPIPacket>, CommandAPIProtocol> packetToProtocol;
    private final String channelIdentifier;
    private final List<Function<FriendlyByteBuffer, ? extends CommandAPIPacket>> idToPacket;
    private final Map<Class<? extends CommandAPIPacket>, Integer> packetToId;

    private CommandAPIProtocol(String channelIdentifier, PacketSetBuilder packetSet) {
        this.channelIdentifier = channelIdentifier;
        this.idToPacket = packetSet.idToPacket;
        this.packetToId = packetSet.packetToId;
    }

    public static Set<String> getAllChannelIdentifiers() {
        return channelIdentifierToProtocol.keySet();
    }

    @Nullable
    public static CommandAPIProtocol getProtocolForPacket(Class<? extends CommandAPIPacket> clazz) {
        return packetToProtocol.get(clazz);
    }

    @Nullable
    public static CommandAPIProtocol getProtocolForChannel(String channelIdentifier) {
        return channelIdentifierToProtocol.get(channelIdentifier);
    }

    public String getChannelIdentifier() {
        return this.channelIdentifier;
    }

    public Set<Class<? extends CommandAPIPacket>> getAllPacketTypes() {
        return this.packetToId.keySet();
    }

    @Nullable
    public CommandAPIPacket createPacket(int id, FriendlyByteBuffer buffer) {
        if (id < 0 || id >= this.idToPacket.size()) {
            return null;
        }
        return this.idToPacket.get(id).apply(buffer);
    }

    public int getId(Class<? extends CommandAPIPacket> clazz) {
        return this.packetToId.getOrDefault(clazz, -1);
    }

    static {
        channelIdentifierToProtocol = new HashMap<String, CommandAPIProtocol>();
        packetToProtocol = new HashMap<Class<? extends CommandAPIPacket>, CommandAPIProtocol>();
        for (CommandAPIProtocol protocol : CommandAPIProtocol.values()) {
            CommandAPIProtocol previousProtocol = channelIdentifierToProtocol.put(protocol.getChannelIdentifier(), protocol);
            if (previousProtocol != null) {
                throw new IllegalStateException("Protocols " + String.valueOf((Object)protocol) + " and " + String.valueOf((Object)previousProtocol) + " cannot share the same channel identifier: \"" + protocol.channelIdentifier + "\"");
            }
            for (Class<? extends CommandAPIPacket> packetType : protocol.getAllPacketTypes()) {
                previousProtocol = packetToProtocol.put(packetType, protocol);
                if (previousProtocol == null) continue;
                throw new IllegalStateException("Packet class \"" + packetType.getSimpleName() + " is already assigned to protocol " + String.valueOf((Object)previousProtocol) + "\nIt cannot also be assigned to protocol " + String.valueOf((Object)protocol));
            }
        }
    }

    private static final class PacketSetBuilder {
        final List<Function<FriendlyByteBuffer, ? extends CommandAPIPacket>> idToPacket = new ArrayList<Function<FriendlyByteBuffer, ? extends CommandAPIPacket>>();
        final Map<Class<? extends CommandAPIPacket>, Integer> packetToId = new HashMap<Class<? extends CommandAPIPacket>, Integer>();

        private PacketSetBuilder() {
        }

        <Packet extends CommandAPIPacket> PacketSetBuilder register(Class<Packet> clazz, Function<FriendlyByteBuffer, Packet> deserializer) {
            if (clazz == null) {
                throw new IllegalStateException("Class cannot be null");
            }
            if (deserializer == null) {
                throw new IllegalStateException("Deserializer cannot be null");
            }
            if (this.packetToId.containsKey(clazz)) {
                throw new IllegalStateException("Packet class \"" + clazz.getSimpleName() + "\" is already registered");
            }
            int id = this.idToPacket.size();
            this.idToPacket.add(deserializer);
            this.packetToId.put(clazz, id);
            return this;
        }
    }
}

