/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.endEvent;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.util.Message;
import net.mathias2246.buildmc.util.config.ConfigurationValidationException;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.player.PlayerPortalEvent;

public class EndListener
implements Listener {
    public static boolean allowEnd = false;
    private static List<EntityType> blockedEntities;

    public static void loadFromConfig() throws ConfigurationValidationException {
        allowEnd = Main.config.getBoolean("end-event.allow-end", false);
        List rawList = Main.config.getStringList("end-event.blocked-entities");
        ArrayList<EntityType> validatedEntities = new ArrayList<EntityType>();
        for (String name : rawList) {
            String upperName = name.toUpperCase();
            try {
                EntityType type = EntityType.valueOf((String)upperName);
                validatedEntities.add(type);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationValidationException("Invalid entity type in end-event.blocked-entities: " + name);
            }
        }
        blockedEntities = validatedEntities;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityPortal(EntityPortalEvent event) {
        World toWorld;
        Entity entity = event.getEntity();
        EntityType type = entity.getType();
        World fromWorld = entity.getWorld();
        World world = toWorld = event.getTo() != null ? event.getTo().getWorld() : null;
        if (toWorld == null) {
            return;
        }
        if (allowEnd) {
            if ((fromWorld.getEnvironment() == World.Environment.THE_END || toWorld.getEnvironment() == World.Environment.THE_END) && blockedEntities.contains(type)) {
                event.setCancelled(true);
            }
        } else if (toWorld.getEnvironment() == World.Environment.THE_END) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPortal(PlayerPortalEvent event) {
        if (allowEnd) {
            return;
        }
        if (event.getPlayer().hasPermission("buildmc.bypass-end-event")) {
            return;
        }
        if (event.getTo() == null || event.getTo().getWorld() == null) {
            return;
        }
        if (event.getTo().getWorld().getEnvironment() == World.Environment.THE_END) {
            event.setCancelled(true);
            Component message = Message.msg(event.getPlayer(), "messages.end-event.closed-message");
            CoreMain.mainClass.sendPlayerActionBar(event.getPlayer(), message);
        }
    }
}

