/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.inventoryframework.abstraction;

import java.util.function.Consumer;
import net.mathias2246.buildmc.inventoryframework.abstraction.util.ObservableValue;
import net.mathias2246.buildmc.inventoryframework.adventuresupport.TextHolder;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class AnvilInventory {
    @NotNull
    protected final @NotNull ObservableValue<@NotNull String> observableText = new ObservableValue<String>("");
    protected short cost;

    public void setCost(short cost) {
        if (cost < 0) {
            throw new IllegalArgumentException("Cost must be non-negative");
        }
        this.cost = cost;
    }

    @NotNull
    public abstract Inventory createInventory(@NotNull TextHolder var1);

    @NotNull
    @Contract(pure=true)
    public String getRenameText() {
        String text = this.observableText.get();
        if (text == null) {
            throw new IllegalStateException("Rename text is null");
        }
        return text;
    }

    public void subscribeToNameInputChanges(@NotNull Consumer<? super String> onNameInputChanged) {
        this.observableText.subscribe(onNameInputChanged);
    }
}

