/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.inventoryframework.pane.util;

import java.util.ArrayList;
import java.util.Arrays;
import net.mathias2246.buildmc.inventoryframework.exception.XMLLoadException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Pattern {
    private final int @NotNull [] @NotNull [] pattern;

    public Pattern(String ... pattern) {
        int rows = pattern.length;
        boolean zeroRows = rows == 0;
        this.pattern = new int[rows][zeroRows ? 0 : pattern[0].codePointCount(0, pattern[0].length())];
        if (zeroRows) {
            return;
        }
        int globalLength = this.pattern[0].length;
        for (int index = 0; index < rows; ++index) {
            String row = pattern[index];
            int length = row.codePointCount(0, row.length());
            if (length != globalLength) {
                throw new IllegalArgumentException("Rows have different lengths, row 1 has " + globalLength + " characters, but row " + index + " has " + length + " characters");
            }
            ArrayList values = new ArrayList();
            row.codePoints().forEach(values::add);
            for (int column = 0; column < values.size(); ++column) {
                this.pattern[index][column] = (Integer)values.get(column);
            }
        }
    }

    private Pattern(int @NotNull [] @NotNull [] pattern) {
        this.pattern = pattern;
    }

    @NotNull
    @Contract(pure=true)
    public Pattern setHeight(int height) {
        int index;
        int[][] newRows = new int[height][this.getLength()];
        for (index = 0; index < Math.min(height, this.getHeight()); ++index) {
            System.arraycopy(this.pattern[index], 0, newRows[index], 0, this.pattern[index].length);
        }
        for (index = Math.min(height, this.getHeight()); index < height; ++index) {
            int[] previousRow = newRows[index - 1];
            newRows[index] = Arrays.copyOf(previousRow, previousRow.length);
        }
        return new Pattern(newRows);
    }

    @NotNull
    @Contract(pure=true)
    public Pattern setLength(int length) {
        int[][] newRows = new int[this.getHeight()][length];
        for (int index = 0; index < this.pattern.length; ++index) {
            int[] newRow = new int[length];
            int[] row = this.pattern[index];
            int minLength = Math.min(length, row.length);
            System.arraycopy(row, 0, newRow, 0, minLength);
            for (int column = minLength; column < length; ++column) {
                newRow[column] = newRow[minLength - 1];
            }
            newRows[index] = newRow;
        }
        return new Pattern(newRows);
    }

    @Contract(pure=true)
    public int @NotNull [] getColumn(int index) {
        if (index >= this.getLength()) {
            throw new IllegalArgumentException("Index " + index + " exceeds pattern length");
        }
        int[] column = new int[this.pattern[0].length];
        for (int i = 0; i < this.getHeight(); ++i) {
            column[i] = this.pattern[i][index];
        }
        return column;
    }

    @Contract(pure=true)
    public boolean contains(int character) {
        int[][] nArray = this.pattern;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] row;
            for (int cell : row = nArray[i]) {
                if (cell != character) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(pure=true)
    public int @NotNull [] getRow(int index) {
        if (index >= this.getHeight()) {
            throw new IllegalArgumentException("Index " + index + " exceeds pattern height");
        }
        int[] row = this.pattern[index];
        return Arrays.copyOf(row, row.length);
    }

    @Contract(pure=true)
    public int getCharacter(int x, int y) {
        if (x < 0 || x >= this.getLength() || y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Position " + x + ", " + y + " is out of range");
        }
        return this.pattern[y][x];
    }

    @Contract(pure=true)
    public int getLength() {
        return this.pattern[0].length;
    }

    @Contract(pure=true)
    public int getHeight() {
        return this.pattern.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Pattern pattern = (Pattern)object;
        return Arrays.deepEquals((Object[])this.pattern, (Object[])pattern.pattern);
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.pattern);
    }

    public String toString() {
        return "Mask{mask=" + Arrays.deepToString((Object[])this.pattern) + '}';
    }

    @NotNull
    @Contract(pure=true)
    public static Pattern load(@NotNull Element element) {
        ArrayList<String> rows = new ArrayList<String>();
        NodeList childNodes = element.getChildNodes();
        for (int itemIndex = 0; itemIndex < childNodes.getLength(); ++itemIndex) {
            Node item = childNodes.item(itemIndex);
            if (item.getNodeType() != 1) continue;
            Element child = (Element)item;
            String name = child.getNodeName();
            if (!name.equals("row")) {
                throw new XMLLoadException("Pattern contains unknown tag " + name);
            }
            rows.add(child.getTextContent());
        }
        return new Pattern(rows.toArray(new String[0]));
    }
}

