/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.status;

import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.platform.SoundManagerSpigotImpl;
import net.mathias2246.buildmc.status.StatusConfig;
import net.mathias2246.buildmc.status.StatusInstance;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class PlayerStatus
implements Listener {
    @NotNull
    public static final NamespacedKey PLAYER_STATUS_PDC = Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:player_status"));

    private static boolean hasStatus(@NotNull Player player) {
        return player.getPersistentDataContainer().has(PLAYER_STATUS_PDC);
    }

    public static boolean doesStatusExist(String status) {
        if (status == null) {
            return false;
        }
        return StatusConfig.loadedStatuses.containsKey(status);
    }

    public static void setPlayerStatus(@NotNull Player player, String status, boolean join) {
        if (!PlayerStatus.doesStatusExist(status)) {
            if (join) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.status.join-doesn't-exist"));
                player.getPersistentDataContainer().remove(PLAYER_STATUS_PDC);
            } else {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.status.not-found"));
                CoreMain.soundManager.playSound(player, SoundManagerSpigotImpl.mistake);
            }
            return;
        }
        StatusInstance s = StatusConfig.loadedStatuses.get(status);
        StatusInstance.AllowStatus allowed = s.allowPlayer(player);
        if (!allowed.equals((Object)StatusInstance.AllowStatus.ALLOW)) {
            switch (allowed) {
                case NOT_IN_TEAM: {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.status.not-in-team"));
                    break;
                }
                case MISSING_PERMISSION: {
                    Main.audiences.player(player).sendMessage(Component.translatable("messages.status.no-permission"));
                }
            }
            if (join) {
                player.getPersistentDataContainer().remove(PLAYER_STATUS_PDC);
                return;
            }
            CoreMain.soundManager.playSound(player, SoundManagerSpigotImpl.mistake);
            return;
        }
        Component c = s.getDisplay().asComponent().append(Component.text(player.getName()));
        String legacy = LegacyComponentSerializer.legacySection().serialize(c);
        player.setPlayerListName(legacy);
        player.setDisplayName(legacy);
        player.setCustomName(legacy);
        player.setCustomNameVisible(true);
        player.getPersistentDataContainer().set(PLAYER_STATUS_PDC, PersistentDataType.STRING, (Object)status);
        if (join) {
            return;
        }
        Main.audiences.player(player).sendMessage(Component.translatable("messages.status.successfully-set"));
        CoreMain.soundManager.playSound(player, SoundManagerSpigotImpl.success);
    }

    public static void removePlayerStatus(@NotNull Player player) {
        player.getPersistentDataContainer().remove(PLAYER_STATUS_PDC);
        player.setPlayerListName(null);
        player.setDisplayName(null);
        player.setCustomName(null);
        player.setCustomNameVisible(false);
    }

    @EventHandler
    public static void onPlayerJoin(PlayerJoinEvent event) {
        if (PlayerStatus.hasStatus(event.getPlayer())) {
            Player player = event.getPlayer();
            PlayerStatus.setPlayerStatus(player, (String)player.getPersistentDataContainer().get(PLAYER_STATUS_PDC, PersistentDataType.STRING), true);
        }
    }
}

