/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.gui.type;

import com.github.stefvanschie.inventoryframework.HumanEntityCache;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.InventoryBased;
import com.github.stefvanschie.inventoryframework.gui.type.util.MergedGui;
import com.github.stefvanschie.inventoryframework.gui.type.util.NamedGui;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ShulkerBoxGui
extends NamedGui
implements MergedGui,
InventoryBased {
    @NotNull
    private InventoryComponent inventoryComponent = new InventoryComponent(9, 7);

    public ShulkerBoxGui(@NotNull String title) {
        super(title);
    }

    public ShulkerBoxGui(@NotNull TextHolder title) {
        super(title);
    }

    public ShulkerBoxGui(@NotNull String title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    public ShulkerBoxGui(@NotNull TextHolder title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    @Override
    public void update() {
        this.updating = true;
        if (this.isDirty()) {
            this.inventory = this.createInventory();
            this.markChanges();
        }
        this.getInventory().clear();
        int height = this.getInventoryComponent().getHeight();
        this.getInventoryComponent().display();
        this.getInventoryComponent().excludeRows(height - 4, height - 1).placeItems(this.getInventory(), 0);
        for (HumanEntity viewer : this.getViewers()) {
            ItemStack cursor = viewer.getItemOnCursor();
            viewer.setItemOnCursor(new ItemStack(Material.AIR));
            this.populateBottomInventory(viewer);
            viewer.setItemOnCursor(cursor);
        }
        if (!this.updating) {
            throw new AssertionError((Object)"Gui#isUpdating became false before Gui#update finished");
        }
        this.updating = false;
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (this.inventory == null) {
            this.update();
        }
        this.populateBottomInventory(humanEntity);
        humanEntity.openInventory(this.getInventory());
    }

    private void populateBottomInventory(@NotNull HumanEntity humanEntity) {
        int height = this.getInventoryComponent().getHeight();
        InventoryComponent bottomComponent = this.getInventoryComponent().excludeRows(0, height - 5);
        if (bottomComponent.hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (!humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            bottomComponent.placeItems(humanEntity.getInventory(), 0);
        }
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public ShulkerBoxGui copy() {
        ShulkerBoxGui gui = new ShulkerBoxGui(this.getTitleHolder(), this.plugin);
        gui.inventoryComponent = this.inventoryComponent.copy();
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    @Contract(pure=true)
    public boolean isPlayerInventoryUsed() {
        return this.getInventoryComponent().excludeRows(0, this.getInventoryComponent().getHeight() - 5).hasItem();
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        this.getInventoryComponent().click(this, event, event.getRawSlot());
    }

    @Override
    public void addPane(@NotNull Pane pane) {
        this.inventoryComponent.addPane(pane);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<Pane> getPanes() {
        return this.inventoryComponent.getPanes();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Collection<GuiItem> getItems() {
        return this.getPanes().stream().flatMap(pane -> pane.getItems().stream()).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        return this.getTitleHolder().asInventoryTitle((InventoryHolder)this, InventoryType.SHULKER_BOX);
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public InventoryComponent getInventoryComponent() {
        return this.inventoryComponent;
    }

    @Nullable
    @Contract(pure=true)
    public static ShulkerBoxGui load(@NotNull Object instance, @NotNull InputStream inputStream, @NotNull Plugin plugin) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            return ShulkerBoxGui.load(instance, documentElement, plugin);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static ShulkerBoxGui load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        if (!element.hasAttribute("title")) {
            throw new XMLLoadException("Provided XML element's gui tag doesn't have the mandatory title attribute set");
        }
        ShulkerBoxGui shulkerBoxGui = new ShulkerBoxGui(element.getAttribute("title"), plugin);
        shulkerBoxGui.initializeOrThrow(instance, element);
        if (element.hasAttribute("populate")) {
            return shulkerBoxGui;
        }
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node item = childNodes.item(index);
            if (item.getNodeType() != 1) continue;
            Element componentElement = (Element)item;
            InventoryComponent inventoryComponent = shulkerBoxGui.getInventoryComponent();
            if (componentElement.getTagName().equalsIgnoreCase("component")) {
                inventoryComponent.load(instance, componentElement, plugin);
                break;
            }
            inventoryComponent.load(instance, element, plugin);
            break;
        }
        return shulkerBoxGui;
    }

    @Nullable
    @Contract(pure=true)
    public static ShulkerBoxGui load(@NotNull Object instance, @NotNull InputStream inputStream) {
        return ShulkerBoxGui.load(instance, inputStream, (Plugin)JavaPlugin.getProvidingPlugin(ShulkerBoxGui.class));
    }

    @NotNull
    public static ShulkerBoxGui load(@NotNull Object instance, @NotNull Element element) {
        return ShulkerBoxGui.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(ShulkerBoxGui.class));
    }
}

