/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane.component;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.font.util.Font;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.Flippable;
import com.github.stefvanschie.inventoryframework.pane.Orientable;
import com.github.stefvanschie.inventoryframework.pane.OutlinePane;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.Rotatable;
import com.github.stefvanschie.inventoryframework.pane.util.Slot;
import java.util.function.BiFunction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class Label
extends OutlinePane {
    @NotNull
    private final Font font;
    @NotNull
    private String text;
    @NotNull
    private final Plugin plugin;

    public Label(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority, @NotNull Font font, @NotNull Plugin plugin) {
        super(slot, length, height);
        this.font = font;
        this.text = "";
        this.plugin = plugin;
        this.setPriority(priority);
    }

    public Label(int x, int y, int length, int height, @NotNull Pane.Priority priority, @NotNull Font font, @NotNull Plugin plugin) {
        this(Slot.fromXY(x, y), length, height, priority, font, plugin);
    }

    public Label(@NotNull Slot slot, int length, int height, @NotNull Font font, @NotNull Plugin plugin) {
        this(slot, length, height, Pane.Priority.NORMAL, font, plugin);
    }

    public Label(int x, int y, int length, int height, @NotNull Font font, @NotNull Plugin plugin) {
        this(x, y, length, height, Pane.Priority.NORMAL, font, plugin);
    }

    public Label(int length, int height, @NotNull Font font, @NotNull Plugin plugin) {
        this(0, 0, length, height, font, plugin);
    }

    public Label(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority, @NotNull Font font) {
        this(slot, length, height, priority, font, (Plugin)JavaPlugin.getProvidingPlugin(Label.class));
    }

    public Label(int x, int y, int length, int height, @NotNull Pane.Priority priority, @NotNull Font font) {
        this(x, y, length, height, priority, font, (Plugin)JavaPlugin.getProvidingPlugin(Label.class));
    }

    public Label(@NotNull Slot slot, int length, int height, @NotNull Font font) {
        this(slot, length, height, Pane.Priority.NORMAL, font);
    }

    public Label(int x, int y, int length, int height, @NotNull Font font) {
        this(x, y, length, height, Pane.Priority.NORMAL, font);
    }

    public Label(int length, int height, @NotNull Font font) {
        this(0, 0, length, height, font);
    }

    public void setText(@NotNull String text, @NotNull @NotNull BiFunction<? super @NotNull Character, ? super @NotNull ItemStack, ? extends @NotNull GuiItem> processor) {
        this.text = text;
        this.clear();
        for (char character : text.toCharArray()) {
            ItemStack item = this.font.toItem(character);
            if (item == null) {
                item = this.font.toItem(Character.toUpperCase(character));
            }
            if (item == null) {
                item = this.font.toItem(Character.toLowerCase(character));
            }
            if (item == null) {
                item = this.font.getDefaultItem();
            }
            this.addItem(processor.apply(Character.valueOf(character), (ItemStack)item.clone()));
        }
    }

    public void setText(@NotNull String text) {
        this.setText(text, (character, item) -> new GuiItem((ItemStack)item, this.plugin));
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Label copy() {
        Label label = new Label(this.getSlot(), this.length, this.height, this.getPriority(), this.font, this.plugin);
        for (GuiItem item : this.getItems()) {
            label.addItem(item.copy());
        }
        label.setVisible(this.isVisible());
        label.onClick = this.onClick;
        label.setOrientation(this.getOrientation());
        label.setRotation(this.getRotation());
        label.setGap(this.getGap());
        label.setRepeat(this.doesRepeat());
        label.flipHorizontally(this.isFlippedHorizontally());
        label.flipVertically(this.isFlippedVertically());
        label.applyMask(this.getMask());
        label.uuid = this.uuid;
        label.text = this.text;
        return label;
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        event.setCancelled(true);
        return super.click(gui, inventoryComponent, event, slot, paneOffsetX, paneOffsetY, maxLength, maxHeight);
    }

    @Contract(pure=true)
    @NotNull
    public String getText() {
        return this.text;
    }

    @Contract(pure=true)
    @NotNull
    public Font getFont() {
        return this.font;
    }

    @NotNull
    @Contract(pure=true)
    public static Label load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        int height;
        int length;
        try {
            length = Integer.parseInt(element.getAttribute("length"));
            height = Integer.parseInt(element.getAttribute("height"));
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
        Font font = null;
        if (element.hasAttribute("font")) {
            font = Font.fromName(element.getAttribute("font"));
        }
        if (font == null) {
            throw new XMLLoadException("Incorrect font specified for label");
        }
        Label label = new Label(length, height, font, plugin);
        Pane.load(label, instance, element);
        Orientable.load(label, element);
        Flippable.load(label, element);
        Rotatable.load(label, element);
        if (element.hasAttribute("populate")) {
            return label;
        }
        if (element.hasAttribute("text")) {
            label.setText(element.getAttribute("text"));
        }
        return label;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static Label load(@NotNull Object instance, @NotNull Element element) {
        return Label.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(Label.class));
    }
}

