/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.api.claims;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.api.claims.Protection;
import org.bukkit.Chunk;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Claim {
    private Long id;
    private final ClaimType type;
    private final String ownerId;
    private final UUID worldId;
    private final int chunkX1;
    private final int chunkZ1;
    private final int chunkX2;
    private final int chunkZ2;
    private final String name;
    private final List<UUID> whitelistedPlayers;
    private final List<String> protections;

    public Claim(@Nullable Long id, @NotNull ClaimType type, @NotNull String ownerId, @NotNull UUID worldId, int chunkX1, int chunkZ1, int chunkX2, int chunkZ2, @NotNull String name, @NotNull List<UUID> whitelistedPlayers, @NotNull List<String> protections) {
        this.id = id;
        this.type = type;
        this.ownerId = ownerId;
        this.worldId = worldId;
        this.chunkX1 = chunkX1;
        this.chunkZ1 = chunkZ1;
        this.chunkX2 = chunkX2;
        this.chunkZ2 = chunkZ2;
        this.name = name;
        this.whitelistedPlayers = new ArrayList<UUID>(whitelistedPlayers);
        this.protections = protections.isEmpty() && type != ClaimType.PLACEHOLDER ? new ArrayList<String>(Protection.defaultProtections) : new ArrayList<String>(protections);
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    public ClaimType getType() {
        return this.type;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public UUID getWorldId() {
        return this.worldId;
    }

    public int getChunkX1() {
        return this.chunkX1;
    }

    public int getChunkZ1() {
        return this.chunkZ1;
    }

    public int getChunkX2() {
        return this.chunkX2;
    }

    public int getChunkZ2() {
        return this.chunkZ2;
    }

    public String getName() {
        return this.name;
    }

    @ApiStatus.Internal
    public void setID(long id) {
        this.id = id;
    }

    public List<UUID> getWhitelistedPlayers() {
        return this.whitelistedPlayers;
    }

    public boolean isPlayerWhitelisted(@NotNull UUID playerID) {
        return this.whitelistedPlayers.contains(playerID);
    }

    public void addWhitelistedPlayer(@NotNull UUID playerId) {
        if (!this.whitelistedPlayers.contains(playerId)) {
            this.whitelistedPlayers.add(playerId);
        }
    }

    public void removeWhitelistedPlayer(@NotNull UUID playerId) {
        this.whitelistedPlayers.remove(playerId);
    }

    public List<String> getProtections() {
        return this.protections;
    }

    public boolean hasProtection(@NotNull NamespacedKey protection) {
        return this.protections.contains(protection.toString());
    }

    public boolean hasProtection(@NotNull Protection protection) {
        return this.protections.contains(protection.getKey().toString());
    }

    public void addProtection(@NotNull NamespacedKey protection) {
        this.protections.add(protection.toString());
    }

    public void removeProtection(@NotNull NamespacedKey protection) {
        this.protections.remove(protection.toString());
    }

    public boolean contains(int chunkX, int chunkZ, UUID worldUUID) {
        if (!this.worldId.equals(worldUUID)) {
            return false;
        }
        int minX = Math.min(this.chunkX1, this.chunkX2);
        int maxX = Math.max(this.chunkX1, this.chunkX2);
        int minZ = Math.min(this.chunkZ1, this.chunkZ2);
        int maxZ = Math.max(this.chunkZ1, this.chunkZ2);
        return chunkX >= minX && chunkX <= maxX && chunkZ >= minZ && chunkZ <= maxZ;
    }

    public boolean contains(@NotNull Chunk chunk) {
        return this.contains(chunk.getX(), chunk.getZ(), chunk.getWorld().getUID());
    }

    public String toString() {
        return "Claim{id=" + this.id + "type=" + String.valueOf((Object)this.type) + ", ownerId='" + this.ownerId + "', worldId=" + String.valueOf(this.worldId) + ", chunkX1=" + this.chunkX1 + ", chunkZ1=" + this.chunkZ1 + ", chunkX2=" + this.chunkX2 + ", chunkZ2=" + this.chunkZ2 + ", name='" + this.name + "', whitelistedPlayers=" + String.valueOf(this.whitelistedPlayers) + ", protections=" + String.valueOf(this.protections) + "}";
    }
}

