/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.item.AbstractCustomItem;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.claims.tool.ClaimToolItemMetaModifier;
import net.mathias2246.buildmc.claims.tools.ClaimSelectionTool;
import net.mathias2246.buildmc.commandAPI.CommandAPICommand;
import net.mathias2246.buildmc.commandAPI.arguments.Argument;
import net.mathias2246.buildmc.commandAPI.arguments.LocationArgument;
import net.mathias2246.buildmc.commandAPI.arguments.NamespacedKeyArgument;
import net.mathias2246.buildmc.commandAPI.arguments.StringArgument;
import net.mathias2246.buildmc.commandAPI.executors.ExecutorType;
import net.mathias2246.buildmc.commands.CommandUtil;
import net.mathias2246.buildmc.commands.CustomCommand;
import net.mathias2246.buildmc.commands.claim.ClaimCreate;
import net.mathias2246.buildmc.commands.claim.ClaimProtections;
import net.mathias2246.buildmc.commands.claim.ClaimRemove;
import net.mathias2246.buildmc.commands.claim.ClaimWhitelist;
import net.mathias2246.buildmc.ui.claims.ClaimSelectMenu;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public class ClaimCommand
implements CustomCommand {
    @Override
    public CommandAPICommand getCommand() {
        ClaimToolItemMetaModifier modifier = new ClaimToolItemMetaModifier();
        ClaimSelectionTool claimTool = (ClaimSelectionTool)Objects.requireNonNull(AbstractCustomItem.customItemsRegistry.get(Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:claim_tool"))));
        boolean isClaimtoolGiveEnabled = Main.config.getBoolean("claims.tool.enable-give-command", true);
        return ((CommandAPICommand)new CommandAPICommand("claim").executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer((CommandSender)command.sender());
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = patt0$temp;
            ClaimSelectMenu.open(player);
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("claimtool").withRequirement(cmd -> isClaimtoolGiveEnabled)).executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer((CommandSender)command.sender());
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = patt0$temp;
            if (player.getInventory().firstEmpty() == -1) {
                Main.audiences.sender((CommandSender)player).sendMessage(Message.msg(player, "messages.claims.tool.full-inventory"));
                return;
            }
            claimTool.giveToPlayer(player, modifier);
            Main.audiences.sender((CommandSender)player).sendMessage(Message.msg(player, "messages.claims.tool.give-success"));
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)new CommandAPICommand("edit").executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer((CommandSender)command.sender());
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = patt0$temp;
            ClaimSelectMenu.open(player);
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("who").executes(command -> {
            Claim claim;
            Player patt0$temp = CommandUtil.requiresPlayer((CommandSender)command.sender());
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            try {
                claim = ClaimManager.getClaim(player.getLocation());
            }
            catch (SQLException e) {
                CoreMain.plugin.getLogger().severe("An error occurred while getting a claim from the database: " + e.getMessage());
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.sql"));
                return 0;
            }
            if (claim == null) {
                Main.audiences.sender((CommandSender)command.sender()).sendMessage(Component.translatable("messages.claims.who.unclaimed"));
                return 1;
            }
            ClaimType claimType = claim.getType();
            if (claimType == ClaimType.TEAM) {
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.who.team-message", Map.of("owner", claim.getOwnerId())));
            } else if (claimType == ClaimType.PLAYER) {
                UUID ownerId = UUID.fromString(claim.getOwnerId());
                OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)ownerId);
                String ownerName = owner.getName();
                if (ownerName == null) {
                    ownerName = "Unknown";
                }
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.who.player-message", Map.of("owner", ownerName)));
            } else if (claimType == ClaimType.SERVER || claimType == ClaimType.PLACEHOLDER) {
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.who.server-message"));
            }
            return 1;
        }, new ExecutorType[0])).withArguments(new Argument[]{(Argument)new LocationArgument("loc").executes(command -> {
            Claim claim;
            Player patt0$temp = CommandUtil.requiresPlayer((CommandSender)command.sender());
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            Location l = command.args().getByClass("loc", Location.class);
            if (l == null) {
                CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.error.general"));
                return 0;
            }
            try {
                claim = ClaimManager.getClaim(l);
            }
            catch (SQLException e) {
                CoreMain.plugin.getLogger().severe("An error occurred while getting a claim from the database: " + e.getMessage());
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.sql"));
                return 0;
            }
            if (claim == null) {
                Main.audiences.sender((CommandSender)command.sender()).sendMessage(Component.translatable("messages.claims.who.unclaimed"));
                return 1;
            }
            ClaimType claimType = claim.getType();
            if (claimType == ClaimType.TEAM) {
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.who.team-message", Map.of("owner", claim.getOwnerId())));
            } else if (claimType == ClaimType.PLAYER) {
                UUID ownerId = UUID.fromString(claim.getOwnerId());
                OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)ownerId);
                String ownerName = owner.getName();
                if (ownerName == null) {
                    ownerName = "Unknown";
                }
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.who.player-message", Map.of("owner", ownerName)));
            } else if (claimType == ClaimType.SERVER || claimType == ClaimType.PLACEHOLDER) {
                Main.audiences.player(player).sendMessage(Message.msg(player, "messages.claims.who.server-message"));
            }
            return 1;
        }, new ExecutorType[0])})).withSubcommand((CommandAPICommand)new CommandAPICommand("help").executes(command -> {
            CommandSender sender = (CommandSender)command.sender();
            Main.audiences.sender(sender).sendMessage(Component.translatable("messages.claims.help-message"));
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withArguments(new Argument[]{(Argument)new StringArgument("type").replaceSuggestions((info, builder) -> {
            Player player;
            builder.suggest("player").suggest("team");
            Object patt0$temp = info.sender();
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("buildmc.admin")) {
                builder.suggest("server").suggest("placeholder");
            }
            return builder.buildFuture();
        })})).withArguments(new Argument[]{new StringArgument("name")})).executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer((CommandSender)command.sender());
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = command.args().getByClass("type", String.class);
            String name = command.args().getByClass("name", String.class);
            if (type == null || name == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.invalid-args"));
                return 0;
            }
            return ClaimCreate.createClaimCommand(player, type, name);
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("remove").withArguments(new Argument[]{(Argument)new StringArgument("type").replaceSuggestions((info, builder) -> {
            Player player;
            builder.suggest("player").suggest("team");
            Object patt0$temp = info.sender();
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("buildmc.admin")) {
                builder.suggest("server").suggest("placeholder");
            }
            return builder.buildFuture();
        }), (Argument)new StringArgument("claim").replaceSuggestions((info, builder) -> {
            Object patt0$temp = info.sender();
            if (!(patt0$temp instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)patt0$temp;
            String type = info.previousArgs().getOrDefault("type", (Object)"").toString().toLowerCase();
            List<Long> claimIds = switch (type) {
                case "player" -> ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                case "team" -> {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        yield List.of();
                    }
                    yield ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
                case "server" -> {
                    if (player.hasPermission("buildmc.admin")) {
                        yield ClaimManager.serverClaims;
                    }
                    yield List.of();
                }
                case "placeholder" -> {
                    if (player.hasPermission("buildmc.admin")) {
                        yield ClaimManager.placeholderClaims;
                    }
                    yield List.of();
                }
                default -> List.of();
            };
            for (Long id : claimIds) {
                String name = ClaimManager.getClaimNameById(id);
                if (name == null || !name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(name);
            }
            return builder.buildFuture();
        })})).executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer((CommandSender)command.sender());
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = command.args().getByClass("type", String.class);
            String claimName = command.args().getByClass("claim", String.class);
            if (type == null || claimName == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.invalid-args"));
                return 0;
            }
            return ClaimRemove.removeClaimCommand(player, type, claimName);
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("whitelist").withArguments(new Argument[]{(Argument)new StringArgument("action").replaceSuggestions((info, builder) -> builder.suggest("add").suggest("remove").buildFuture()), (Argument)new StringArgument("type").replaceSuggestions((info, builder) -> {
            Player player;
            builder.suggest("player").suggest("team");
            Object patt0$temp = info.sender();
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("buildmc.admin")) {
                builder.suggest("server");
            }
            return builder.buildFuture();
        }), (Argument)new StringArgument("claim").replaceSuggestions((info, builder) -> {
            Object patt0$temp = info.sender();
            if (!(patt0$temp instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)patt0$temp;
            String type = info.previousArgs().getOrDefault("type", (Object)"").toString().toLowerCase();
            List<Long> claimIds = switch (type) {
                case "player" -> ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                case "team" -> {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        yield List.of();
                    }
                    yield ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
                case "server" -> {
                    if (player.hasPermission("buildmc.admin")) {
                        yield ClaimManager.serverClaims;
                    }
                    yield List.of();
                }
                default -> List.of();
            };
            for (Long claimId : claimIds) {
                String name = ClaimManager.getClaimNameById(claimId);
                if (name == null) continue;
                builder.suggest(name);
            }
            return builder.buildFuture();
        }), (Argument)new StringArgument("targetPlayer").replaceSuggestions((info, builder) -> {
            CommandSender sender = (CommandSender)info.sender();
            if (!(sender instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)sender;
            List<String> inputArgs = List.of(info.currentInput().split(" "));
            if (inputArgs.size() < 4) {
                return builder.buildFuture();
            }
            String type = inputArgs.get(2);
            String claimName = inputArgs.get(3);
            List<Long> claimIds = switch (type.toLowerCase()) {
                case "player" -> ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                case "team" -> {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        yield List.of();
                    }
                    yield ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
                case "server" -> {
                    if (player.hasPermission("buildmc.admin")) {
                        yield ClaimManager.serverClaims;
                    }
                    yield List.of();
                }
                default -> List.of();
            };
            for (Long claimId : claimIds) {
                Claim claim;
                String name = ClaimManager.getClaimNameById(claimId);
                if (name == null || !name.equalsIgnoreCase(claimName) || (claim = ClaimManager.getClaimByID(claimId)) == null) continue;
                List<UUID> whitelisted = claim.getWhitelistedPlayers();
                Team team = ClaimManager.getPlayerTeam(player);
                Bukkit.getOnlinePlayers().stream().filter(p -> claim.getType().equals((Object)ClaimType.SERVER) || !p.getUniqueId().equals(player.getUniqueId())).filter(p -> team == null || !team.hasEntry(p.getName())).filter(p -> !whitelisted.contains(p.getUniqueId())).map(Player::getName).forEach(builder::suggest);
                break;
            }
            return builder.buildFuture();
        })})).executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer((CommandSender)command.sender());
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String action = command.args().getByClass("action", String.class);
            String type = command.args().getByClass("type", String.class);
            String claimName = command.args().getByClass("claim", String.class);
            String targetPlayerName = command.args().getByClass("targetPlayer", String.class);
            if (action == null || type == null || claimName == null || targetPlayerName == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.invalid-args"));
                return 0;
            }
            return ClaimWhitelist.whitelistClaimCommand(player, type, claimName, action, targetPlayerName);
        }, new ExecutorType[0])).withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("protections").withArguments(new Argument[]{(Argument)new StringArgument("type").replaceSuggestions((info, builder) -> {
            Player player;
            builder.suggest("player").suggest("team");
            Object patt0$temp = info.sender();
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("buildmc.admin")) {
                builder.suggest("server");
            }
            return builder.buildFuture();
        }), (Argument)new StringArgument("claim").replaceSuggestions((info, builder) -> {
            List<Object> claimIds;
            Object patt0$temp = info.sender();
            if (!(patt0$temp instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)patt0$temp;
            String type = info.previousArgs().getOrDefault("type", (Object)"").toString().toLowerCase();
            switch (type) {
                case "player": {
                    claimIds = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                    break;
                }
                case "team": {
                    Team team = ClaimManager.getPlayerTeam(player);
                    if (team == null) {
                        return builder.buildFuture();
                    }
                    claimIds = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                    break;
                }
                case "server": {
                    if (!player.hasPermission("buildmc.admin")) {
                        return builder.buildFuture();
                    }
                    claimIds = ClaimManager.serverClaims;
                    break;
                }
                default: {
                    claimIds = List.of();
                }
            }
            for (Long claimId : claimIds) {
                String name = ClaimManager.getClaimNameById(claimId);
                if (name == null || !name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(name);
            }
            return builder.buildFuture();
        }), (Argument)new NamespacedKeyArgument("flag").replaceSuggestions((info, builder) -> {
            String remaining = builder.getRemaining();
            Iterator<Protection> iterator = CoreMain.protectionsRegistry.iterator();
            while (iterator.hasNext()) {
                Protection flag = iterator.next();
                String s = flag.getKey().toString();
                if (flag.isHidden() || !s.startsWith(remaining.toLowerCase())) continue;
                builder.suggest(s);
            }
            return builder.buildFuture();
        }), (Argument)new StringArgument("value").replaceSuggestions((info, builder) -> builder.suggest("true").suggest("false").buildFuture())})).executes(command -> {
            boolean enable;
            Player patt0$temp = CommandUtil.requiresPlayer((CommandSender)command.sender());
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = command.args().getByClass("type", String.class);
            String claimName = command.args().getByClass("claim", String.class);
            NamespacedKey flag = command.args().getByClass("flag", NamespacedKey.class);
            String value = command.args().getByClass("value", String.class);
            if (type == null || claimName == null || flag == null || value == null) {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.error.invalid-args"));
                return 0;
            }
            type = type.toLowerCase();
            if ((value = value.toLowerCase()).equals("true")) {
                enable = true;
            } else if (value.equals("false")) {
                enable = false;
            } else {
                Main.audiences.player(player).sendMessage(Component.translatable("messages.claims.protections.invalid-value"));
                return 0;
            }
            return ClaimProtections.changeClaimProtections(player, flag, enable, type, claimName);
        }, new ExecutorType[0]));
    }
}

