/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.mathias2246.buildmc.api.claims.Protection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ClaimLogger {
    private static boolean enabled;
    private static Path logDir;
    private static int retentionDays;
    private static LocalTime rotationTime;
    private static boolean mirrorToConsole;
    private static LocalDate currentLogDate;
    private static Path currentLogFile;
    private static Plugin plugin;
    private static final DateTimeFormatter FILE_DATE_FORMAT;
    private static final DateTimeFormatter LOG_TIME_FORMAT;

    public static void init(Plugin pluginInstance) {
        plugin = pluginInstance;
        enabled = plugin.getConfig().getBoolean("claims.logs.enabled", true);
        retentionDays = plugin.getConfig().getInt("claims.logs.retention-days", 14);
        String rotationTimeStr = plugin.getConfig().getString("claims.logs.rotation-time", "00:00");
        mirrorToConsole = plugin.getConfig().getBoolean("claims.logs.mirror-to-console", false);
        rotationTime = LocalTime.parse(rotationTimeStr);
        logDir = plugin.getDataFolder().toPath().resolve("logs/claims");
        if (!enabled) {
            return;
        }
        try {
            Files.createDirectories(logDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to create claim log directory!", e);
            enabled = false;
            return;
        }
        ClaimLogger.rotateIfNeeded();
        ClaimLogger.startRotationTask();
    }

    private static void startRotationTask() {
        long ticksUntilNextCheck = 12000L;
        plugin.getServer().getScheduler().runTaskTimer(plugin, ClaimLogger::rotateIfNeeded, 0L, ticksUntilNextCheck);
    }

    private static long computeTicksUntilNextRotation() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime next = now.toLocalDate().atTime(rotationTime);
        if (!next.isAfter(now)) {
            next = next.plusDays(1L);
        }
        Duration duration = Duration.between(now, next);
        return duration.getSeconds() * 20L;
    }

    private static synchronized void rotateIfNeeded() {
        LocalDateTime now = LocalDateTime.now();
        if (!now.toLocalDate().equals(currentLogDate) || now.toLocalTime().isAfter(rotationTime) && currentLogDate.equals(LocalDate.now().minusDays(1L))) {
            currentLogDate = now.toLocalDate();
            currentLogFile = logDir.resolve("claims-" + FILE_DATE_FORMAT.format(currentLogDate) + ".log");
            ClaimLogger.cleanupOldLogs();
        }
    }

    private static void cleanupOldLogs() {
        if (retentionDays < 0) {
            return;
        }
        try (Stream<Path> files = Files.list(logDir);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                try {
                    String name = path.getFileName().toString();
                    String datePart = name.replace("claims-", "").replace(".log", "");
                    LocalDate fileDate = LocalDate.parse(datePart, FILE_DATE_FORMAT);
                    return fileDate.isBefore(LocalDate.now().minusDays(retentionDays));
                }
                catch (Exception e) {
                    return false;
                }
            }).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Failed to clean up old claim logs", e);
        }
    }

    public static synchronized void log(String message) {
        if (!enabled) {
            return;
        }
        ClaimLogger.rotateIfNeeded();
        String timestamp = LocalDateTime.now().format(LOG_TIME_FORMAT);
        String line = "[" + timestamp + "] " + message + System.lineSeparator();
        try {
            Files.writeString(currentLogFile, (CharSequence)line, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to write to claim log file", e);
        }
        if (mirrorToConsole) {
            plugin.getLogger().info("[ClaimLogs] " + message);
        }
    }

    private static synchronized String formatPlayer(Player player) {
        return player.getName() + " (" + String.valueOf(player.getUniqueId()) + ")";
    }

    public static synchronized void logClaimCreated(Player player, String claimName) {
        ClaimLogger.log(String.format("[CLAIM CREATED] %s created claim '%s'", ClaimLogger.formatPlayer(player), claimName));
    }

    public static synchronized void logClaimDeleted(Player player, String claimName) {
        ClaimLogger.log(String.format("[CLAIM DELETED] %s deleted claim '%s'", ClaimLogger.formatPlayer(player), claimName));
    }

    public static synchronized void logProtectionChanged(Player player, String claimName, String protectionName, String newValue) {
        ClaimLogger.log(String.format("[PROTECTION CHANGE] %s changed '%s' to '%s' in claim '%s'", ClaimLogger.formatPlayer(player), protectionName, newValue, claimName));
    }

    public static synchronized void logProtectionChanged(Player player, String claimName, Protection protection, String newValue) {
        ClaimLogger.logProtectionChanged(player, claimName, protection.getKey().toString(), newValue);
    }

    public static synchronized void logWhitelistAdded(Player player, String claimName, Player target) {
        ClaimLogger.log(String.format("[WHITELIST ADDED] %s added %s (%s) to claim '%s'", ClaimLogger.formatPlayer(player), target.getName(), target.getUniqueId(), claimName));
    }

    public static synchronized void logWhitelistRemoved(Player player, String claimName, Player target) {
        ClaimLogger.log(String.format("[WHITELIST REMOVED] %s removed %s (%s) from claim '%s'", ClaimLogger.formatPlayer(player), target.getName(), target.getUniqueId(), claimName));
    }

    public static synchronized void logWhitelistAdded(Player player, String claimName, String targetName, String targetUUID) {
        ClaimLogger.log(String.format("[WHITELIST ADDED] %s added %s (%s) to claim '%s'", ClaimLogger.formatPlayer(player), targetName, targetUUID, claimName));
    }

    public static synchronized void logWhitelistRemoved(Player player, String claimName, String targetName, String targetUUID) {
        ClaimLogger.log(String.format("[WHITELIST REMOVED] %s removed %s (%s) from claim '%s'", ClaimLogger.formatPlayer(player), targetName, targetUUID, claimName));
    }

    static {
        FILE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LOG_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }
}

