/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.claims.ClaimManager;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimManagerImpl
implements net.mathias2246.buildmc.api.claims.ClaimManager {
    @Override
    @Nullable
    public Team getPlayerTeam(@NotNull Player player) {
        return ClaimManager.getPlayerTeam(player);
    }

    @Override
    public boolean isWorldAllowed(@NotNull World world) {
        return ClaimManager.isWorldAllowed(world);
    }

    @Override
    public boolean isPlayerAllowed(@NotNull Player player, @NotNull Collection<NamespacedKey> protections, Location location) {
        return ClaimManager.isPlayerAllowed(player, protections, location);
    }

    @Override
    public boolean isPlayerAllowed(@NotNull Player player, @NotNull Collection<NamespacedKey> protections, @Nullable Claim claim) {
        return ClaimManager.isPlayerAllowed(player, protections, claim);
    }

    @Override
    public boolean isPlayerAllowed(@NotNull Player player, @NotNull NamespacedKey protection, @Nullable Claim claim) {
        return ClaimManager.isPlayerAllowed(player, protection, claim);
    }

    @Override
    public boolean isPlayerAllowed(@NotNull Player player, @NotNull NamespacedKey protection, Location location) {
        return ClaimManager.isPlayerAllowed(player, protection, location);
    }

    @Override
    public boolean hasAnyProtection(Claim claim, Collection<NamespacedKey> protections) {
        return ClaimManager.hasAnyProtection(claim, protections);
    }

    @Override
    public boolean hasProtection(Claim claim, NamespacedKey protection) {
        return ClaimManager.hasProtection(claim, protection);
    }

    @Override
    public boolean hasAllProtections(Claim claim, Collection<String> flags) {
        return ClaimManager.hasAllProtections(claim, flags);
    }

    @Override
    public boolean hasAllProtectionKeys(Claim claim, Collection<NamespacedKey> keys) {
        return ClaimManager.hasAllProtectionKeys(claim, keys);
    }

    @Override
    public boolean isClaimInArea(UUID worldID, int chunkX1, int chunkZ1, int chunkX2, int chunkZ2) throws SQLException {
        return ClaimManager.isClaimInArea(worldID, chunkX1, chunkZ1, chunkX2, chunkZ2);
    }

    @Override
    public List<Claim> getClaimsInArea(Location pos1, Location pos2) throws SQLException, IllegalArgumentException {
        return ClaimManager.getClaimsInArea(pos1, pos2);
    }

    @Override
    public boolean isClaimed(Chunk chunk) {
        return ClaimManager.isClaimed(chunk);
    }

    @Override
    @Nullable
    public Long getClaimId(Chunk chunk) {
        return ClaimManager.getClaimId(chunk);
    }

    @Override
    @Nullable
    public Claim getClaim(Chunk chunk) throws SQLException {
        return ClaimManager.getClaim(chunk);
    }

    @Override
    @Nullable
    public Claim getClaimByID(long claimID) {
        return ClaimManager.getClaimByID(claimID);
    }

    @Override
    @Nullable
    public Claim getClaim(Location location) throws SQLException {
        return ClaimManager.getClaim(location);
    }

    @Override
    public List<Claim> getAllClaims() throws SQLException {
        return ClaimManager.getAllClaims();
    }

    @Override
    public boolean tryClaimPlayerArea(@NotNull Player player, String claimName, Location pos1, Location pos2) throws IllegalArgumentException {
        if (pos1 == null || pos2 == null) {
            throw new IllegalArgumentException("Positions cannot be null.");
        }
        if (pos1.getWorld() == null || pos2.getWorld() == null) {
            throw new IllegalArgumentException("Both locations must have a world.");
        }
        if (!pos1.getWorld().equals((Object)pos2.getWorld())) {
            throw new IllegalArgumentException("Locations must be in the same world.");
        }
        return ClaimManager.tryClaimPlayerArea(player, claimName, pos1, pos2);
    }

    @Override
    public boolean tryClaimTeamArea(@NotNull Team team, String claimName, Location pos1, Location pos2) throws IllegalArgumentException {
        if (pos1 == null || pos2 == null) {
            throw new IllegalArgumentException("Positions cannot be null.");
        }
        if (pos1.getWorld() == null || pos2.getWorld() == null) {
            throw new IllegalArgumentException("Both locations must have a world.");
        }
        if (!pos1.getWorld().equals((Object)pos2.getWorld())) {
            throw new IllegalArgumentException("Locations must be in the same world.");
        }
        return ClaimManager.tryClaimTeamArea(team, claimName, pos1, pos2);
    }

    @Override
    public boolean tryClaimServerArea(String claimName, Location pos1, Location pos2) throws IllegalArgumentException {
        if (pos1 == null || pos2 == null) {
            throw new IllegalArgumentException("Positions cannot be null.");
        }
        if (pos1.getWorld() == null || pos2.getWorld() == null) {
            throw new IllegalArgumentException("Both locations must have a world.");
        }
        if (!pos1.getWorld().equals((Object)pos2.getWorld())) {
            throw new IllegalArgumentException("Locations must be in the same world.");
        }
        return ClaimManager.tryClaimServerArea(claimName, pos1, pos2);
    }

    @Override
    public boolean tryClaimPlaceholderArea(String claimName, Location pos1, Location pos2) throws IllegalArgumentException {
        if (pos1 == null || pos2 == null) {
            throw new IllegalArgumentException("Positions cannot be null.");
        }
        if (pos1.getWorld() == null || pos2.getWorld() == null) {
            throw new IllegalArgumentException("Both locations must have a world.");
        }
        if (!pos1.getWorld().equals((Object)pos2.getWorld())) {
            throw new IllegalArgumentException("Locations must be in the same world.");
        }
        return ClaimManager.tryClaimPlaceholderArea(claimName, pos1, pos2);
    }

    @Override
    public void addPlayerToWhitelist(long claimID, UUID playerID) {
        ClaimManager.addPlayerToWhitelist(claimID, playerID);
    }

    @Override
    public void removePlayerFromWhitelist(long claimID, UUID playerID) {
        ClaimManager.removePlayerFromWhitelist(claimID, playerID);
    }

    @Override
    public void addProtection(long claimId, @NotNull Protection protection) {
        ClaimManager.addProtection(claimId, protection);
    }

    @Override
    public void addProtection(long claimId, @NotNull NamespacedKey protection) {
        ClaimManager.addProtection(claimId, protection);
    }

    @Override
    public void removeProtection(long claimId, @NotNull Protection protection) {
        ClaimManager.removeProtection(claimId, protection);
    }

    @Override
    public void removeProtection(long claimId, @NotNull NamespacedKey protection) {
        ClaimManager.removeProtection(claimId, protection);
    }

    @Override
    @Nullable
    public String getClaimNameById(long claimId) {
        return ClaimManager.getClaimNameById(claimId);
    }

    @Override
    public boolean removeClaimById(long claimId) {
        return ClaimManager.removeClaimById(claimId);
    }

    @Override
    public boolean doesOwnerHaveClaimWithName(String ownerId, String claimName) throws SQLException {
        return ClaimManager.doesOwnerHaveClaimWithName(ownerId, claimName);
    }

    @Override
    @Nullable
    public Integer getRemainingTeamClaims(String teamName) {
        return ClaimManager.getRemainingTeamClaims(teamName);
    }

    @Override
    @Nullable
    public Integer getRemainingPlayerClaims(String playerUUID) {
        return ClaimManager.getRemainingPlayerClaims(playerUUID);
    }

    @Override
    @Nullable
    public Integer getRemainingPlayerClaims(UUID playerUUID) {
        return ClaimManager.getRemainingPlayerClaims(playerUUID);
    }

    @Override
    public void setRemainingTeamClaims(String teamName, @Nullable Integer remainingClaims) {
        ClaimManager.setRemainingTeamClaims(teamName, remainingClaims);
    }

    @Override
    public void setRemainingPlayerClaims(String playerUUID, @Nullable Integer remainingClaims) {
        ClaimManager.setRemainingPlayerClaims(playerUUID, remainingClaims);
    }

    @Override
    public void setRemainingPlayerClaims(UUID playerUUID, @Nullable Integer remainingClaims) {
        ClaimManager.setRemainingPlayerClaims(playerUUID, remainingClaims);
    }
}

