/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.commandAPI.arguments;

import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.mathias2246.buildmc.commandAPI.arguments.CommandAPIArgumentType;
import net.mathias2246.buildmc.commandAPI.arguments.SafeOverrideableArgument;
import net.mathias2246.buildmc.commandAPI.exceptions.InvalidRangeException;
import net.mathias2246.buildmc.commandAPI.executors.CommandArguments;

public class LongArgument
extends SafeOverrideableArgument<Long, Long> {
    public LongArgument(String nodeName) {
        super(nodeName, LongArgumentType.longArg(), String::valueOf);
    }

    public LongArgument(String nodeName, long min) {
        super(nodeName, LongArgumentType.longArg(min), String::valueOf);
    }

    public LongArgument(String nodeName, long min, long max) {
        super(nodeName, LongArgumentType.longArg(min, max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Long> getPrimitiveType() {
        return Long.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_LONG;
    }

    @Override
    public <Source> Long parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

