/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.commands.claim;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.claims.ClaimLogger;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.util.LocationUtil;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public class ClaimCreate {
    public static int createClaimCommand(@NotNull Player player, String type, String name) {
        List<Claim> overlappingClaims;
        if (!player.hasMetadata("buildmc:claim_tool_first_selection") || !player.hasMetadata("buildmc:claim_tool_second_selection")) {
            CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.missing-positions"));
            return 0;
        }
        Location pos1 = LocationUtil.tryDeserialize(((MetadataValue)player.getMetadata("buildmc:claim_tool_first_selection").getFirst()).asString());
        Location pos2 = LocationUtil.tryDeserialize(((MetadataValue)player.getMetadata("buildmc:claim_tool_second_selection").getFirst()).asString());
        if (pos1 == null || pos2 == null) {
            CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.missing-positions"));
            return 0;
        }
        if (!Objects.equals(pos1.getWorld(), pos2.getWorld())) {
            CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.different-worlds"));
            return 0;
        }
        if (!player.hasPermission("buildmc.bypass-claim-dimension-list") && !ClaimManager.isWorldAllowed(Objects.requireNonNull(pos1.getWorld()))) {
            CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.world-not-allowed"));
            return 0;
        }
        try {
            overlappingClaims = ClaimManager.getClaimsInArea(pos1, pos2);
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("There was an error while getting the claims in an area: " + e.getMessage());
            CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.error-database"));
            return 0;
        }
        if (!overlappingClaims.isEmpty()) {
            boolean serverProtected = overlappingClaims.stream().anyMatch(claim -> claim.getType() == ClaimType.SERVER);
            if (serverProtected) {
                CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.protected-server"));
            } else {
                CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.overlap"));
            }
            return 0;
        }
        int newClaimChunks = LocationUtil.calculateChunkArea(pos1, pos2);
        switch (type.toLowerCase()) {
            case "player": {
                int maxChunksAllowed = CoreMain.plugin.getConfig().getInt("claims.player-max-chunk-claim-amount");
                int remainingChunks = ClaimManager.playerRemainingClaims.getOrDefault(player.getUniqueId().toString(), maxChunksAllowed);
                if (remainingChunks - newClaimChunks < 0) {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Message.msg(player, "messages.claims.create.no-remaining-claims", Map.of("no-remaining-claims", String.valueOf(remainingChunks))));
                    return 0;
                }
                try {
                    if (ClaimManager.doesOwnerHaveClaimWithName(player.getUniqueId().toString(), name)) {
                        CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.duplicate-name"));
                        return 1;
                    }
                }
                catch (SQLException e) {
                    CoreMain.plugin.getLogger().severe("SQL Error while trying to check claim name availability: " + String.valueOf(e));
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.error-database"));
                    return 0;
                }
                boolean success = ClaimManager.tryClaimPlayerArea(player, name, pos1, pos2);
                if (success) {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Message.msg(player, "messages.claims.create.success", Map.of("remaining_claims", String.valueOf(remainingChunks - newClaimChunks))));
                    ClaimCreate.removeSelectionData(player);
                    ClaimLogger.logClaimCreated(player, name);
                    return 1;
                }
                CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.failed"));
                return 0;
            }
            case "team": {
                Team team = ClaimManager.getPlayerTeam(player);
                if (team == null) {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.error.not-in-a-team"));
                    return 0;
                }
                int maxChunksAllowed = CoreMain.plugin.getConfig().getInt("claims.team-max-chunk-claim-amount");
                int remainingChunks = ClaimManager.teamRemainingClaims.getOrDefault(team.getName(), maxChunksAllowed);
                if (remainingChunks - newClaimChunks < 0) {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Message.msg(player, "messages.claims.create.no-remaining-claims", Map.of("remaining_claims", String.valueOf(remainingChunks))));
                    return 0;
                }
                try {
                    if (ClaimManager.doesOwnerHaveClaimWithName(team.getName(), name)) {
                        CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.duplicate-name"));
                        return 1;
                    }
                }
                catch (SQLException e) {
                    CoreMain.plugin.getLogger().severe("SQL Error while trying to check claim name availability: " + String.valueOf(e));
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.error-database"));
                    return 0;
                }
                boolean success = ClaimManager.tryClaimTeamArea(team, name, pos1, pos2);
                if (success) {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Message.msg(player, "messages.claims.create.success", Map.of("remaining_claims", String.valueOf(remainingChunks - newClaimChunks))));
                    ClaimCreate.removeSelectionData(player);
                    ClaimLogger.logClaimCreated(player, name);
                    return 1;
                }
                CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.failed"));
                return 0;
            }
            case "server": 
            case "placeholder": {
                boolean success;
                if (!player.hasPermission("buildmc.admin")) {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.error.no-permission"));
                    return 0;
                }
                try {
                    if (ClaimManager.doesOwnerHaveClaimWithName(type.toLowerCase(), name)) {
                        CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.duplicate-name"));
                        return 1;
                    }
                }
                catch (SQLException e) {
                    CoreMain.plugin.getLogger().severe("SQL Error while trying to check claim name availability: " + String.valueOf(e));
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.error-database"));
                    return 0;
                }
                switch (type.toLowerCase()) {
                    case "server": {
                        boolean bl = ClaimManager.tryClaimServerArea(name, pos1, pos2);
                        break;
                    }
                    case "placeholder": {
                        boolean bl = ClaimManager.tryClaimPlaceholderArea(name, pos1, pos2);
                        break;
                    }
                    default: {
                        boolean bl = success = false;
                    }
                }
                if (success) {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Message.msg(player, "messages.claims.create.success-" + type.toLowerCase(), Map.of("claim_name", name)));
                    ClaimCreate.removeSelectionData(player);
                    ClaimLogger.logClaimCreated(player, name);
                    return 1;
                }
                CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.failed"));
                return 0;
            }
        }
        CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.create.invalid-type"));
        return 0;
    }

    private static void removeSelectionData(Player player) {
        player.removeMetadata("buildmc:claim_tool_first_selection", CoreMain.plugin);
        player.removeMetadata("buildmc:claim_tool_second_selection", CoreMain.plugin);
    }
}

