/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.endEvent;

import java.io.IOException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.api.endEvent.EndChangeCause;
import net.mathias2246.buildmc.api.endEvent.EndManager;
import net.mathias2246.buildmc.api.endEvent.EndState;
import net.mathias2246.buildmc.api.event.endevent.EndStateChangeEvent;
import net.mathias2246.buildmc.endEvent.EndListener;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndManagerImpl
implements EndManager {
    private static final String OPEN_ANNOUNCEMENT_KEY = "messages.end-event.broadcast-opened";
    private static final String CLOSE_ANNOUNCEMENT_KEY = "messages.end-event.broadcast-closed";

    @Override
    public boolean openEnd(@Nullable CommandSender sender, @NotNull EndChangeCause cause, @NotNull String announcementKey) {
        return this.changeEndState(EndState.OPEN, sender, cause, announcementKey);
    }

    @Override
    public boolean closeEnd(@Nullable CommandSender sender, @NotNull EndChangeCause cause, @NotNull String announcementKey) {
        return this.changeEndState(EndState.CLOSED, sender, cause, announcementKey);
    }

    @Override
    public boolean openEnd(@Nullable CommandSender sender, @NotNull EndChangeCause cause) {
        return this.openEnd(sender, cause, OPEN_ANNOUNCEMENT_KEY);
    }

    @Override
    public boolean closeEnd(@Nullable CommandSender sender, @NotNull EndChangeCause cause) {
        return this.closeEnd(sender, cause, CLOSE_ANNOUNCEMENT_KEY);
    }

    @Override
    @NotNull
    public EndState getCurrentState() {
        return EndListener.allowEnd ? EndState.OPEN : EndState.CLOSED;
    }

    private boolean changeEndState(@NotNull EndState targetState, @Nullable CommandSender sender, @NotNull EndChangeCause cause, @NotNull String announcementKey) {
        EndStateChangeEvent event = new EndStateChangeEvent(targetState, this.getCurrentState(), cause, sender, announcementKey);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        boolean allowEnd = event.getNewState() != EndState.CLOSED;
        this.performChangeLogic(event.getAnnouncementKey(), allowEnd);
        return true;
    }

    private void performChangeLogic(String announcementKey, boolean allowEnd) {
        EndListener.allowEnd = allowEnd;
        Main.config.set("end-event.allow-end", (Object)allowEnd);
        try {
            Main.config.save(Main.configFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TranslatableComponent msg = Component.translatable(announcementKey);
        for (Player player : Bukkit.getOnlinePlayers()) {
            CoreMain.mainClass.sendMessage((CommandSender)player, msg);
        }
    }
}

