/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.inventoryframework.abstraction.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObservableValue<T> {
    @NotNull
    private final Collection<Consumer<? super T>> subscribers = new HashSet<Consumer<? super T>>();
    @Nullable
    private T value;

    public ObservableValue(@Nullable T defaultValue) {
        this.value = defaultValue;
    }

    public void set(T newValue) {
        for (Consumer<T> subscriber : this.subscribers) {
            subscriber.accept(newValue);
        }
        this.value = newValue;
    }

    public void subscribe(@NotNull Consumer<? super T> consumer) {
        this.subscribers.add(consumer);
    }

    @Nullable
    @Contract(pure=true)
    public T get() {
        return this.value;
    }
}

