/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.inventoryframework.pane.component;

import net.mathias2246.buildmc.inventoryframework.exception.XMLLoadException;
import net.mathias2246.buildmc.inventoryframework.gui.InventoryComponent;
import net.mathias2246.buildmc.inventoryframework.gui.type.util.Gui;
import net.mathias2246.buildmc.inventoryframework.pane.Flippable;
import net.mathias2246.buildmc.inventoryframework.pane.Orientable;
import net.mathias2246.buildmc.inventoryframework.pane.Pane;
import net.mathias2246.buildmc.inventoryframework.pane.component.util.VariableBar;
import net.mathias2246.buildmc.inventoryframework.pane.util.Slot;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class Slider
extends VariableBar {
    public Slider(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority, @NotNull Plugin plugin) {
        super(slot, length, height, priority, plugin);
    }

    public Slider(int x, int y, int length, int height, @NotNull Pane.Priority priority, @NotNull Plugin plugin) {
        super(x, y, length, height, priority, plugin);
    }

    public Slider(@NotNull Slot slot, int length, int height, @NotNull Plugin plugin) {
        super(slot, length, height, plugin);
    }

    public Slider(int x, int y, int length, int height, @NotNull Plugin plugin) {
        super(x, y, length, height, plugin);
    }

    public Slider(int length, int height, @NotNull Plugin plugin) {
        super(length, height, plugin);
    }

    public Slider(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority) {
        super(slot, length, height, priority);
    }

    public Slider(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        super(x, y, length, height, priority);
    }

    public Slider(@NotNull Slot slot, int length, int height) {
        super(slot, length, height);
    }

    public Slider(int x, int y, int length, int height) {
        super(x, y, length, height);
    }

    public Slider(int length, int height) {
        super(length, height);
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        Slot paneSlot = this.getSlot();
        int xPosition = paneSlot.getX(maxLength);
        int yPosition = paneSlot.getY(maxLength);
        int totalLength = inventoryComponent.getLength();
        int adjustedSlot = slot - (xPosition + paneOffsetX) - totalLength * (yPosition + paneOffsetY);
        int x = adjustedSlot % totalLength;
        int y = adjustedSlot / totalLength;
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        if (this.orientation == Orientable.Orientation.HORIZONTAL) {
            this.setValue((float)(x + 1) / (float)length);
        } else if (this.orientation == Orientable.Orientation.VERTICAL) {
            this.setValue((float)(y + 1) / (float)height);
        } else {
            throw new UnsupportedOperationException("Unknown orientation");
        }
        this.callOnClick(event);
        int newPaneOffsetX = paneOffsetX + xPosition;
        int newPaneOffsetY = paneOffsetY + yPosition;
        boolean success = this.fillPane.click(gui, inventoryComponent, event, slot, newPaneOffsetX, newPaneOffsetY, length, height) || this.backgroundPane.click(gui, inventoryComponent, event, slot, newPaneOffsetX, newPaneOffsetY, length, height);
        gui.update();
        return success;
    }

    @Override
    public void setValue(float value) {
        super.setValue(value);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Slider copy() {
        Slider slider = new Slider(this.getSlot(), this.length, this.height, this.getPriority());
        this.applyContents(slider);
        return slider;
    }

    public float getValue() {
        return this.value;
    }

    @NotNull
    @Contract(pure=true)
    public static Slider load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        int height;
        int length;
        try {
            length = Integer.parseInt(element.getAttribute("length"));
            height = Integer.parseInt(element.getAttribute("height"));
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
        Slider slider = new Slider(length, height, plugin);
        Pane.load(slider, instance, element);
        Orientable.load(slider, element);
        Flippable.load(slider, element);
        if (element.hasAttribute("populate")) {
            return slider;
        }
        if (element.hasAttribute("value")) {
            try {
                slider.setValue(Float.parseFloat(element.getAttribute("value")));
            }
            catch (IllegalArgumentException exception) {
                throw new XMLLoadException(exception);
            }
        }
        return slider;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static Slider load(@NotNull Object instance, @NotNull Element element) {
        return Slider.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(Slider.class));
    }
}

