/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.inventoryframework.pane.component;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.mathias2246.buildmc.inventoryframework.exception.XMLLoadException;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.gui.InventoryComponent;
import net.mathias2246.buildmc.inventoryframework.gui.type.util.Gui;
import net.mathias2246.buildmc.inventoryframework.pane.OutlinePane;
import net.mathias2246.buildmc.inventoryframework.pane.Pane;
import net.mathias2246.buildmc.inventoryframework.pane.util.Slot;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class ToggleButton
extends Pane {
    private final OutlinePane enabledPane;
    private final OutlinePane disabledPane;
    private boolean enabled;
    private boolean allowToggle = true;

    public ToggleButton(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority, boolean enabled, @NotNull Plugin plugin) {
        super(slot, length, height, priority);
        this.enabled = enabled;
        this.enabledPane = new OutlinePane(length, height);
        this.enabledPane.addItem(new GuiItem(new ItemStack(Material.GREEN_STAINED_GLASS_PANE), plugin));
        this.enabledPane.setRepeat(true);
        this.disabledPane = new OutlinePane(length, height);
        this.disabledPane.addItem(new GuiItem(new ItemStack(Material.RED_STAINED_GLASS_PANE), plugin));
        this.disabledPane.setRepeat(true);
    }

    public ToggleButton(int x, int y, int length, int height, @NotNull Pane.Priority priority, boolean enabled, @NotNull Plugin plugin) {
        this(Slot.fromXY(x, y), length, height, priority, enabled, plugin);
    }

    public ToggleButton(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority, @NotNull Plugin plugin) {
        this(slot, length, height, priority, false, plugin);
    }

    public ToggleButton(int x, int y, int length, int height, @NotNull Pane.Priority priority, @NotNull Plugin plugin) {
        this(x, y, length, height, priority, false, plugin);
    }

    public ToggleButton(@NotNull Slot slot, int length, int height, boolean enabled, @NotNull Plugin plugin) {
        this(slot, length, height, Pane.Priority.NORMAL, enabled, plugin);
    }

    public ToggleButton(int x, int y, int length, int height, boolean enabled, @NotNull Plugin plugin) {
        this(x, y, length, height, Pane.Priority.NORMAL, enabled, plugin);
    }

    public ToggleButton(@NotNull Slot slot, int length, int height, @NotNull Plugin plugin) {
        this(slot, length, height, false, plugin);
    }

    public ToggleButton(int x, int y, int length, int height, @NotNull Plugin plugin) {
        this(x, y, length, height, false, plugin);
    }

    public ToggleButton(int length, int height, boolean enabled, @NotNull Plugin plugin) {
        this(0, 0, length, height, enabled);
    }

    public ToggleButton(int length, int height, @NotNull Plugin plugin) {
        this(length, height, false);
    }

    public ToggleButton(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority, boolean enabled) {
        this(slot, length, height, priority, enabled, (Plugin)JavaPlugin.getProvidingPlugin(ToggleButton.class));
    }

    public ToggleButton(int x, int y, int length, int height, @NotNull Pane.Priority priority, boolean enabled) {
        this(x, y, length, height, priority, enabled, (Plugin)JavaPlugin.getProvidingPlugin(ToggleButton.class));
    }

    public ToggleButton(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority) {
        this(slot, length, height, priority, false);
    }

    public ToggleButton(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        this(x, y, length, height, priority, false);
    }

    public ToggleButton(@NotNull Slot slot, int length, int height, boolean enabled) {
        this(slot, length, height, Pane.Priority.NORMAL, enabled);
    }

    public ToggleButton(int x, int y, int length, int height, boolean enabled) {
        this(x, y, length, height, Pane.Priority.NORMAL, enabled);
    }

    public ToggleButton(@NotNull Slot slot, int length, int height) {
        this(slot, length, height, false);
    }

    public ToggleButton(int x, int y, int length, int height) {
        this(x, y, length, height, false);
    }

    public ToggleButton(int length, int height, boolean enabled) {
        this(0, 0, length, height, enabled);
    }

    public ToggleButton(int length, int height) {
        this(length, height, false);
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int newMaxLength = Math.min(maxLength, this.length);
        int newMaxHeight = Math.min(maxHeight, this.height);
        int newPaneOffsetX = this.slot.getX(newMaxLength) + paneOffsetX;
        int newPaneOffsetY = this.slot.getY(newMaxHeight) + paneOffsetY;
        if (this.enabled) {
            this.enabledPane.display(inventoryComponent, newPaneOffsetX, newPaneOffsetY, newMaxLength, newMaxHeight);
        } else {
            this.disabledPane.display(inventoryComponent, newPaneOffsetX, newPaneOffsetY, newMaxLength, newMaxHeight);
        }
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        Slot paneSlot = this.getSlot();
        int xPosition = paneSlot.getX(maxLength);
        int yPosition = paneSlot.getY(maxLength);
        int totalLength = inventoryComponent.getLength();
        int adjustedSlot = slot - (xPosition + paneOffsetX) - totalLength * (yPosition + paneOffsetY);
        int x = adjustedSlot % totalLength;
        int y = adjustedSlot / totalLength;
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        if (this.allowToggle) {
            this.toggle();
        }
        this.callOnClick(event);
        int newX = paneOffsetX + xPosition;
        int newY = paneOffsetY + yPosition;
        if (this.enabled == this.allowToggle) {
            this.disabledPane.click(gui, inventoryComponent, event, slot, newX, newY, length, height);
        } else {
            this.enabledPane.click(gui, inventoryComponent, event, slot, newX, newY, length, height);
        }
        gui.update();
        return true;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public ToggleButton copy() {
        ToggleButton toggleButton = new ToggleButton(this.getSlot(), this.length, this.height, this.getPriority(), this.enabled);
        toggleButton.allowToggle = this.allowToggle;
        toggleButton.setVisible(this.isVisible());
        toggleButton.onClick = this.onClick;
        toggleButton.uuid = this.uuid;
        toggleButton.setEnabledItem(((GuiItem)this.enabledPane.getItems().get(0)).copy());
        toggleButton.setDisabledItem(((GuiItem)this.disabledPane.getItems().get(0)).copy());
        return toggleButton;
    }

    @Override
    public void setLength(int length) {
        super.setLength(length);
        this.disabledPane.setLength(length);
        this.enabledPane.setLength(length);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.disabledPane.setHeight(height);
        this.enabledPane.setHeight(height);
    }

    public void setDisabledItem(@NotNull GuiItem item) {
        this.disabledPane.clear();
        this.disabledPane.addItem(item);
    }

    public void setEnabledItem(@NotNull GuiItem item) {
        this.enabledPane.clear();
        this.enabledPane.addItem(item);
    }

    @Override
    @NotNull
    public Collection<GuiItem> getItems() {
        return this.getPanes().stream().flatMap(pane -> pane.getItems().stream()).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<Pane> getPanes() {
        return Stream.of(this.enabledPane, this.disabledPane).collect(Collectors.toSet());
    }

    public void allowToggle(boolean allowToggle) {
        this.allowToggle = allowToggle;
    }

    @Contract(pure=true)
    public boolean isEnabled() {
        return this.enabled;
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    @Override
    public void clear() {
    }

    @NotNull
    @Contract(pure=true)
    public static ToggleButton load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        int height;
        int length;
        try {
            length = Integer.parseInt(element.getAttribute("length"));
            height = Integer.parseInt(element.getAttribute("height"));
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
        boolean enabled = element.hasAttribute("enabled") && Boolean.parseBoolean(element.getAttribute("enabled"));
        ToggleButton toggleButton = new ToggleButton(length, height, enabled, plugin);
        Pane.load(toggleButton, instance, element);
        return toggleButton;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static ToggleButton load(@NotNull Object instance, @NotNull Element element) {
        return ToggleButton.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(ToggleButton.class));
    }
}

