/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.player;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.event.player.PlayerSpawnTeleportPreConditionEvent;
import net.mathias2246.buildmc.util.Message;
import net.mathias2246.buildmc.util.PlayerTimer;
import net.mathias2246.buildmc.util.SoundUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class TeleportTimer
extends PlayerTimer {
    public static final int seconds = CoreMain.plugin.getConfig().getInt("spawn-teleport.wait-for");
    private Vector previousPosition;
    @NotNull
    private final Location to;

    public static int teleportCommandLogic(@NotNull Player player) {
        PlayerSpawnTeleportPreConditionEvent e = new PlayerSpawnTeleportPreConditionEvent(player, player.getWorld().getSpawnLocation());
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.spawn-teleport.not-working"));
            return 0;
        }
        TeleportTimer timer = new TeleportTimer(player, e.getTo());
        timer.start(0);
        return 1;
    }

    public TeleportTimer(@NotNull Player player, @NotNull Location to) {
        super(CoreMain.plugin, player, seconds, 20);
        this.to = to;
    }

    @Override
    public void onExit() {
        CoreMain.mainClass.sendMessage((CommandSender)this.player, Component.translatable("messages.teleport.successful"));
        this.player.teleport(this.to);
        CoreMain.soundManager.playSound(this.player, SoundUtil.success);
    }

    @Override
    protected void init() {
        this.previousPosition = this.player.getLocation().toVector();
    }

    @Override
    protected boolean shouldCancel() {
        return !this.player.isOnline() || !this.player.getLocation().toVector().equals((Object)this.previousPosition);
    }

    @Override
    protected void onCancel() {
        CoreMain.mainClass.sendMessage((CommandSender)this.player, Component.translatable("messages.teleport.cancelled"));
        CoreMain.soundManager.playSound(this.player, SoundUtil.mistake);
    }

    @Override
    protected void onStep() {
        TextReplacementConfig r = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%seconds%").replacement(String.valueOf(this.steps - this.currentStep)).build();
        CoreMain.mainClass.sendPlayerActionBar(this.player, Message.msg(this.player, "messages.teleport.counter").replaceText(r));
        CoreMain.soundManager.playSound(this.player, SoundUtil.notification);
    }
}

