/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.spawnElytra;

import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.spawnElytra.ElytraZoneManager;
import net.mathias2246.buildmc.spawnElytra.SpawnElytraUtil;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;

public record ElytraCheckListeners(ElytraZoneManager zoneManager, boolean boostEnabled, double multiplyValue) implements Listener
{
    @EventHandler
    public void onDoubleJump(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (!SpawnElytraUtil.isSurvival(player)) {
            return;
        }
        if (!this.zoneManager.isInZone(player)) {
            return;
        }
        event.setCancelled(true);
        if (player.isGliding()) {
            return;
        }
        SpawnElytraUtil.setPlayerFlying(player);
        if (this.boostEnabled && !SpawnElytraUtil.isPlayerBoosted(player)) {
            CoreMain.pluginMain.sendPlayerActionBar(player, Component.translatable("messages.spawn-elytra.boost-hint"));
        }
    }

    @EventHandler
    public void onSwapItem(PlayerSwapHandItemsEvent event) {
        if (!this.boostEnabled) {
            return;
        }
        Player player = event.getPlayer();
        if (!SpawnElytraUtil.isUsingSpawnElytra(player) || SpawnElytraUtil.isPlayerBoosted(player)) {
            return;
        }
        event.setCancelled(true);
        SpawnElytraUtil.applyBoost(player, this.multiplyValue, 1.2);
    }

    @EventHandler
    public static void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (SpawnElytraUtil.isUsingSpawnElytra(player) && (event.getCause() == EntityDamageEvent.DamageCause.FALL || event.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public static void onToggleGlide(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (SpawnElytraUtil.isUsingSpawnElytra(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityMount(EntityMountEvent event) {
        Entity entity = event.getEntity();
        if (SpawnElytraUtil.isUsingSpawnElytra(entity) && entity instanceof Player) {
            Player player = (Player)entity;
            SpawnElytraUtil.stopFlying(player);
        }
    }

    @EventHandler
    public void onGamemodeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        GameMode oldMode = player.getGameMode();
        GameMode newMode = event.getNewGameMode();
        if (SpawnElytraUtil.isSurvival(oldMode) && !SpawnElytraUtil.isSurvival(newMode) && SpawnElytraUtil.isUsingSpawnElytra(player)) {
            SpawnElytraUtil.stopFlying(player);
        }
    }
}

