/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.spawnElytra;

import java.io.IOException;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ElytraZoneManager {
    private Location pos1;
    private Location pos2;
    private BoundingBox boundingBox;
    private World world;

    public void setPos1(@NotNull Player player, @NotNull Location loc) {
        this.pos1 = loc;
        CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.spawn-elytra.pos1-set"));
        this.tryCreateZone(player);
    }

    public void setPos2(@NotNull Player player, @NotNull Location loc) {
        this.pos2 = loc;
        CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.spawn-elytra.pos2-set"));
        this.tryCreateZone(player);
    }

    private void tryCreateZone(@NotNull Player player) {
        if (this.pos1 == null || this.pos2 == null) {
            return;
        }
        if (!Objects.equals(this.pos1.getWorld(), this.pos2.getWorld())) {
            CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.spawn-elytra.error.different-worlds"));
            return;
        }
        this.boundingBox = BoundingBox.of((Vector)this.pos1.toVector(), (Vector)this.pos2.toVector());
        this.world = this.pos1.getWorld();
        this.saveZoneToConfig();
        CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.spawn-elytra.success"));
    }

    public void registerZone(@NotNull Location pos1, @NotNull Location pos2, @NotNull World world) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.world = world;
        this.boundingBox = BoundingBox.of((Vector)pos1.toVector(), (Vector)pos2.toVector());
        this.saveZoneToConfig();
    }

    public boolean isInZone(@NotNull Player player) {
        return this.isInZone(player.getLocation());
    }

    public boolean isInZone(@NotNull Location location) {
        if (this.boundingBox == null || this.world == null) {
            return false;
        }
        return this.world.equals((Object)location.getWorld()) && this.boundingBox.contains(location.toVector());
    }

    private void saveZoneToConfig() {
        CoreMain.config.set("spawn-elytra.zone.world", (Object)this.world.getName());
        CoreMain.config.set("spawn-elytra.zone.pos1.x", (Object)this.pos1.getX());
        CoreMain.config.set("spawn-elytra.zone.pos1.y", (Object)this.pos1.getY());
        CoreMain.config.set("spawn-elytra.zone.pos1.z", (Object)this.pos1.getZ());
        CoreMain.config.set("spawn-elytra.zone.pos2.x", (Object)this.pos2.getX());
        CoreMain.config.set("spawn-elytra.zone.pos2.y", (Object)this.pos2.getY());
        CoreMain.config.set("spawn-elytra.zone.pos2.z", (Object)this.pos2.getZ());
        try {
            CoreMain.config.save(CoreMain.configFile);
        }
        catch (IOException e) {
            CoreMain.pluginMain.getLogger().warning("Failed to save config file: " + e.getMessage());
        }
    }

    public void loadZoneFromConfig() {
        String worldName = CoreMain.config.getString("spawn-elytra.zone.world");
        if (worldName == null) {
            return;
        }
        this.world = Bukkit.getWorld((String)worldName);
        if (this.world == null) {
            CoreMain.pluginMain.getLogger().warning("ElytraZoneManager: World '" + worldName + "' not found.");
            return;
        }
        try {
            double x1 = CoreMain.config.getDouble("spawn-elytra.zone.pos1.x");
            double y1 = CoreMain.config.getDouble("spawn-elytra.zone.pos1.y");
            double z1 = CoreMain.config.getDouble("spawn-elytra.zone.pos1.z");
            double x2 = CoreMain.config.getDouble("spawn-elytra.zone.pos2.x");
            double y2 = CoreMain.config.getDouble("spawn-elytra.zone.pos2.y");
            double z2 = CoreMain.config.getDouble("spawn-elytra.zone.pos2.z");
            this.pos1 = new Location(this.world, x1, y1, z1);
            this.pos2 = new Location(this.world, x2, y2, z2);
            this.boundingBox = BoundingBox.of((Vector)this.pos1.toVector(), (Vector)this.pos2.toVector());
        }
        catch (Exception e) {
            CoreMain.pluginMain.getLogger().warning("ElytraZoneManager: Failed to load elytra zone from config: " + e.getMessage());
        }
    }
}

