/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.spawnElytra;

import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.spawnElytra.ElytraZoneManager;
import net.mathias2246.buildmc.spawnElytra.SpawnElytraUtil;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.scheduler.BukkitRunnable;

public class SpawnBoostListener
extends BukkitRunnable
implements Listener {
    private final FileConfiguration config;
    private final ElytraZoneManager zoneManager;

    public SpawnBoostListener(ElytraZoneManager zoneManager) {
        this.zoneManager = zoneManager;
        this.config = CoreMain.plugin.getConfig();
        this.runTaskTimer(CoreMain.plugin, 0L, 3L);
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!SpawnElytraUtil.isSurvival(player)) continue;
            if (SpawnElytraUtil.isUsingSpawnElytra(player) && !player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isAir()) {
                SpawnElytraUtil.stopFlying(player);
                continue;
            }
            if (player.isGliding()) continue;
            boolean inZone = this.zoneManager.isInZone(player);
            player.setAllowFlight(inZone);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.config.getBoolean("spawn-elytra.on-join-elytra-check", true)) {
            return;
        }
        Player player = event.getPlayer();
        SpawnElytraUtil.stopFlying(player);
        if (SpawnElytraUtil.isSurvival(player)) {
            player.setAllowFlight(false);
        }
    }
}

