/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.status;

import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.event.player.StatusChangeEvent;
import net.mathias2246.buildmc.api.status.StatusInstance;
import net.mathias2246.buildmc.util.SoundUtil;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerStatusUtil
implements Listener {
    @NotNull
    public static final NamespacedKey PLAYER_STATUS_PDC = Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:player_status"));

    private static boolean hasStatus(@NotNull Player player) {
        return player.getPersistentDataContainer().has(PLAYER_STATUS_PDC);
    }

    public static void setPlayerStatus(@NotNull Player player, String status, boolean join) {
        StatusInstance.AllowStatus allowed;
        if (!PlayerStatusUtil.doesStatusExist(status)) {
            if (join) {
                CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.status.join-doesn't-exist"));
                player.getPersistentDataContainer().remove(PLAYER_STATUS_PDC);
            } else {
                CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.status.not-found"));
                CoreMain.soundManager.playSound(player, SoundUtil.mistake);
            }
            return;
        }
        @Nullable StatusInstance old = CoreMain.statusesRegistry.get(Objects.requireNonNull(NamespacedKey.fromString((String)("buildmc:" + (String)player.getPersistentDataContainer().get(PLAYER_STATUS_PDC, PersistentDataType.STRING)))));
        StatusInstance s = CoreMain.statusesRegistry.getOrThrow(Objects.requireNonNull(NamespacedKey.fromString((String)("buildmc:" + status))));
        if (!join) {
            StatusChangeEvent e = new StatusChangeEvent(player, old, s);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.status.cannot-set"));
                return;
            }
            if (e.getNewStatus() == null) {
                CoreMain.statusManager.forceRemovePlayerStatus(player);
                return;
            }
        }
        if (!(allowed = s.allowPlayer(player)).equals((Object)StatusInstance.AllowStatus.ALLOW)) {
            switch (allowed) {
                case NOT_IN_TEAM: {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.status.not-in-team"));
                    break;
                }
                case MISSING_PERMISSION: {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.status.no-permission"));
                }
            }
            if (join) {
                player.getPersistentDataContainer().remove(PLAYER_STATUS_PDC);
                return;
            }
            CoreMain.soundManager.playSound(player, SoundUtil.mistake);
            return;
        }
        Component c = s.getDisplay().asComponent().append(Component.text(player.getName()));
        CoreMain.statusManager.setPlayerName(player, c);
        player.getPersistentDataContainer().set(PLAYER_STATUS_PDC, PersistentDataType.STRING, (Object)status);
        if (join) {
            return;
        }
        CoreMain.bukkitAudiences.player(player).sendMessage(Component.translatable("messages.status.successfully-set"));
        CoreMain.soundManager.playSound(player, SoundUtil.success);
    }

    public static boolean doesStatusExist(String status) {
        if (status == null) {
            return false;
        }
        return CoreMain.statusesRegistry.contains(Objects.requireNonNull(NamespacedKey.fromString((String)("buildmc:" + status))));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (PlayerStatusUtil.hasStatus(event.getPlayer())) {
            Player player = event.getPlayer();
            CoreMain.statusManager.setPlayerStatus(player, (String)player.getPersistentDataContainer().get(PLAYER_STATUS_PDC, PersistentDataType.STRING), true);
        }
    }
}

