/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.ui;

import java.util.Objects;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.item.ItemUtil;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.pane.StaticPane;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class UIUtil {
    @NotNull
    public static final GuiItem BLOCKED_PANE;
    @NotNull
    public static final GuiItem INVISIBLE_PANE;
    @NotNull
    public static final GuiItem EXIT_BUTTON;
    @NotNull
    public static final Sound CLICK_SOUND;
    @NotNull
    public static final NamespacedKey INVISIBLE_ITEM_KEY;
    public static final Consumer<InventoryClickEvent> noInteract;
    public static final Consumer<InventoryClickEvent> exitButton;
    public static final StaticPane BOTTOM_BAR_WITH_EXIT;
    public static final StaticPane BOTTOM_BAR;
    @NotNull
    public static final GuiItem LAST_PAGE_BUTTON;
    @NotNull
    public static final GuiItem NEXT_PAGE_BUTTON;

    public static GuiItem makeGuiItem(@NotNull ItemStack item, Consumer<InventoryClickEvent> onClick) {
        return new GuiItem(item, onClick, CoreMain.plugin);
    }

    static {
        CLICK_SOUND = Sound.sound(Key.key(CoreMain.plugin.getConfig().getString("sounds.ui.click", "minecraft:ui.button.click")), Sound.Source.UI, 1.0f, 1.0f);
        INVISIBLE_ITEM_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"nations:none"));
        noInteract = event -> event.setCancelled(true);
        exitButton = event -> {
            event.setCancelled(true);
            event.getWhoClicked().closeInventory();
        };
        ItemStack i1 = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemStack i2 = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemUtil.editMeta(i1, meta -> {
            meta.setItemName(null);
            meta.setHideTooltip(true);
        });
        ItemUtil.editMeta(i2, meta -> {
            meta.setItemName(null);
            meta.setHideTooltip(true);
        });
        ItemStack e = new ItemStack(Material.BARRIER);
        ItemUtil.editMeta(e, meta -> {
            meta.setItemName(null);
            meta.setRarity(ItemRarity.COMMON);
        });
        ItemStack lp = new ItemStack(Material.ARROW);
        ItemUtil.editMeta(lp, meta -> meta.setItemName(null));
        ItemStack np = new ItemStack(Material.ARROW);
        ItemUtil.editMeta(np, meta -> meta.setItemName(null));
        BLOCKED_PANE = new GuiItem(i1, noInteract);
        INVISIBLE_PANE = new GuiItem(i2, noInteract);
        EXIT_BUTTON = new GuiItem(e, exitButton);
        LAST_PAGE_BUTTON = new GuiItem(lp, noInteract);
        NEXT_PAGE_BUTTON = new GuiItem(np, noInteract);
        BOTTOM_BAR_WITH_EXIT = new StaticPane(0, 5, 9, 1);
        BOTTOM_BAR = new StaticPane(0, 5, 9, 1);
        BOTTOM_BAR_WITH_EXIT.addItem(BLOCKED_PANE, 0, 0);
        BOTTOM_BAR_WITH_EXIT.addItem(BLOCKED_PANE, 1, 0);
        BOTTOM_BAR_WITH_EXIT.addItem(BLOCKED_PANE, 2, 0);
        BOTTOM_BAR_WITH_EXIT.addItem(BLOCKED_PANE, 3, 0);
        BOTTOM_BAR_WITH_EXIT.addItem(EXIT_BUTTON, 4, 0);
        BOTTOM_BAR_WITH_EXIT.addItem(BLOCKED_PANE, 5, 0);
        BOTTOM_BAR_WITH_EXIT.addItem(BLOCKED_PANE, 6, 0);
        BOTTOM_BAR_WITH_EXIT.addItem(BLOCKED_PANE, 7, 0);
        BOTTOM_BAR_WITH_EXIT.addItem(BLOCKED_PANE, 8, 0);
        BOTTOM_BAR.addItem(BLOCKED_PANE, 0, 0);
        BOTTOM_BAR.addItem(BLOCKED_PANE, 1, 0);
        BOTTOM_BAR.addItem(BLOCKED_PANE, 2, 0);
        BOTTOM_BAR.addItem(BLOCKED_PANE, 3, 0);
        BOTTOM_BAR.addItem(BLOCKED_PANE, 4, 0);
        BOTTOM_BAR.addItem(BLOCKED_PANE, 5, 0);
        BOTTOM_BAR.addItem(BLOCKED_PANE, 6, 0);
        BOTTOM_BAR.addItem(BLOCKED_PANE, 7, 0);
        BOTTOM_BAR.addItem(BLOCKED_PANE, 8, 0);
    }
}

