/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.ui.claims;

import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.event.claims.ClaimProtectionChangeEvent;
import net.mathias2246.buildmc.claims.ClaimLogger;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.inventoryframework.adventuresupport.ComponentHolder;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.gui.type.ChestGui;
import net.mathias2246.buildmc.inventoryframework.pane.PaginatedPane;
import net.mathias2246.buildmc.inventoryframework.pane.StaticPane;
import net.mathias2246.buildmc.ui.UIUtil;
import net.mathias2246.buildmc.ui.claims.ClaimEditMenu;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtectionsMenu {
    public static void open(Player player, Claim claim) {
        List<Protection> allFlags = CoreMain.protectionsRegistry.stream().toList();
        int flagsPerPage = 18;
        int totalPages = Math.max(1, (int)Math.ceil((double)allFlags.size() / (double)flagsPerPage));
        ChestGui gui = new ChestGui(6, ComponentHolder.of(Message.msg(player, "messages.claims.ui.protections-menu.title", Map.of("claim", claim.getName()))));
        PaginatedPane pages = new PaginatedPane(0, 0, 9, 5);
        for (int page = 0; page < totalPages; ++page) {
            StaticPane pane = new StaticPane(0, 0, 9, 5);
            for (int y = 0; y < 5; ++y) {
                for (int x = 0; x < 9; ++x) {
                    pane.addItem(UIUtil.INVISIBLE_PANE, x, y);
                }
            }
            int start = page * flagsPerPage;
            int end = Math.min(start + flagsPerPage, allFlags.size());
            int index = 0;
            for (int i = start; i < end; ++i) {
                Protection protection = allFlags.get(i);
                if (protection.isHidden()) continue;
                int x = index % 9;
                int y = index < 9 ? 0 : 3;
                int statusRow = index < 9 ? 1 : 4;
                pane.addItem(protection.getDisplay(player, gui), x, y);
                GuiItem statusItem = ProtectionsMenu.makeStatusItem(gui, pane, claim, protection, x, statusRow, player);
                if (statusItem != null) {
                    pane.addItem(statusItem, x, statusRow);
                }
                ++index;
            }
            for (int x = 0; x < 9; ++x) {
                pane.addItem(new GuiItem(ProtectionsMenu.createGlassPane(), UIUtil.noInteract), x, 2);
            }
            pages.addPane(page, pane);
        }
        pages.setPage(0);
        gui.addPane(pages);
        StaticPane controls = new StaticPane(0, 5, 9, 1);
        GuiItem grayItem = new GuiItem(ProtectionsMenu.createGlassPane(), e -> e.setCancelled(true));
        for (int i = 0; i < 9; ++i) {
            controls.addItem(grayItem, i, 0);
        }
        ProtectionsMenu.updatePageIndicator(player, controls, pages.getPage() + 1, totalPages, pages, gui);
        controls.addItem(new GuiItem(ProtectionsMenu.createNamedItem(Material.BARRIER, Message.msg(player, "messages.claims.ui.general.back")), e -> {
            e.setCancelled(true);
            CoreMain.soundManager.playSound(player, UIUtil.CLICK_SOUND);
            ClaimEditMenu.open(player, claim);
        }), 8, 0);
        gui.addPane(controls);
        gui.show((HumanEntity)player);
    }

    @Nullable
    private static GuiItem makeStatusItem(ChestGui gui, StaticPane pane, Claim claim, Protection protection, int x, int y, @NotNull Player player) {
        boolean enabled = claim.hasProtection(protection);
        ItemStack status = ProtectionsMenu.createStatusPane(protection.getKey(), enabled, player);
        Long claimId = claim.getId();
        if (claimId == null) {
            return null;
        }
        return new GuiItem(status, event -> {
            event.setCancelled(true);
            CoreMain.soundManager.playSound(player, UIUtil.CLICK_SOUND);
            boolean currentlyEnabled = claim.hasProtection(protection);
            ClaimProtectionChangeEvent.ActiveState newState = currentlyEnabled ? ClaimProtectionChangeEvent.ActiveState.DISABLED : ClaimProtectionChangeEvent.ActiveState.ENABLED;
            ClaimProtectionChangeEvent changeEvent = new ClaimProtectionChangeEvent(claim, protection, newState, (CommandSender)player);
            if (changeEvent.isCancelled()) {
                return;
            }
            if (currentlyEnabled) {
                ClaimManager.removeProtection((long)claimId, protection);
                ClaimLogger.logProtectionChanged(player, claim.getName(), protection, "disabled");
            } else {
                ClaimManager.addProtection((long)claimId, protection);
                ClaimLogger.logProtectionChanged(player, claim.getName(), protection, "enabled");
            }
            GuiItem updated = ProtectionsMenu.makeStatusItem(gui, pane, claim, protection, x, y, player);
            if (updated != null) {
                pane.addItem(updated, x, y);
                gui.update();
            }
        });
    }

    private static ItemStack createStatusPane(NamespacedKey protection, boolean enabled, @NotNull Player player) {
        Material color = enabled ? Material.GREEN_STAINED_GLASS_PANE : Material.RED_STAINED_GLASS_PANE;
        ItemStack item = new ItemStack(color);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(Message.msg(player, enabled ? "messages.claims.ui.protections-menu.enabled" : "messages.claims.ui.protections-menu.disabled")));
            item.setItemMeta(meta);
        }
        return item;
    }

    private static ItemStack createGlassPane() {
        ItemStack pane = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = pane.getItemMeta();
        if (meta != null) {
            meta.setHideTooltip(true);
            pane.setItemMeta(meta);
        }
        return pane;
    }

    private static ItemStack createNamedItem(Material material, Component name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(name));
            item.setItemMeta(meta);
        }
        return item;
    }

    private static void updatePageIndicator(Player player, StaticPane controls, int current, int total, PaginatedPane pages, ChestGui gui) {
        controls.removeItem(2, 0);
        controls.removeItem(4, 0);
        controls.removeItem(6, 0);
        ItemStack pageIndicator = new ItemStack(Material.PAPER);
        ItemMeta meta = pageIndicator.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(Message.msg(player, "messages.claims.ui.general.page-indicator", Map.of("current", String.valueOf(current), "total", String.valueOf(total)))));
            pageIndicator.setItemMeta(meta);
        }
        controls.addItem(new GuiItem(pageIndicator, e -> e.setCancelled(true)), 4, 0);
        if (current > 1) {
            controls.addItem(new GuiItem(ProtectionsMenu.createNamedItem(Material.ARROW, Message.msg(player, "messages.claims.ui.general.previous")), e -> {
                e.setCancelled(true);
                CoreMain.soundManager.playSound(player, UIUtil.CLICK_SOUND);
                int newPage = pages.getPage() - 1;
                pages.setPage(newPage);
                ProtectionsMenu.updatePageIndicator(player, controls, newPage + 1, total, pages, gui);
                gui.update();
            }), 2, 0);
        } else {
            controls.addItem(new GuiItem(ProtectionsMenu.createGlassPane(), UIUtil.noInteract), 2, 0);
        }
        if (current < total) {
            controls.addItem(new GuiItem(ProtectionsMenu.createNamedItem(Material.ARROW, Message.msg(player, "messages.claims.ui.general.next")), e -> {
                e.setCancelled(true);
                CoreMain.soundManager.playSound(player, UIUtil.CLICK_SOUND);
                int newPage = pages.getPage() + 1;
                pages.setPage(newPage);
                ProtectionsMenu.updatePageIndicator(player, controls, newPage + 1, total, pages, gui);
                gui.update();
            }), 6, 0);
        } else {
            controls.addItem(new GuiItem(ProtectionsMenu.createGlassPane(), UIUtil.noInteract), 6, 0);
        }
    }
}

