/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.util.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseRegistry<T extends Keyed>
implements Registry<T>,
Iterable<T> {
    private final HashMap<NamespacedKey, T> registry = new HashMap();

    @NotNull
    public T addEntry(@NotNull T entry) {
        this.registry.put(entry.getKey(), entry);
        return entry;
    }

    @SafeVarargs
    public final void addEntries(T ... entries) {
        for (T e : entries) {
            this.registry.putIfAbsent(e.getKey(), e);
        }
    }

    public boolean contains(@NotNull NamespacedKey namespacedKey) {
        return this.registry.containsKey(Objects.requireNonNull(namespacedKey));
    }

    public Set<NamespacedKey> keySet() {
        return this.registry.keySet();
    }

    public int size() {
        return this.registry.size();
    }

    @Nullable
    public T get(@NotNull NamespacedKey namespacedKey) {
        return (T)((Keyed)this.registry.get(namespacedKey));
    }

    @NotNull
    public T getOrThrow(@NotNull NamespacedKey namespacedKey) {
        return (T)Objects.requireNonNull((Keyed)this.registry.get(namespacedKey));
    }

    @NotNull
    public Stream<T> stream() {
        return this.registry.values().stream();
    }

    @NotNull
    public Stream<NamespacedKey> keyStream() {
        return this.registry.keySet().stream();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.registry.values().iterator();
    }

    @Nullable
    public T match(@NotNull String input) {
        return (T)super.match(input);
    }

    @NotNull
    public Optional<T> getOptional(@NotNull NamespacedKey namespacedKey) {
        return Optional.ofNullable((Keyed)this.registry.get(namespacedKey));
    }

    @NotNull
    public Optional<T> getOptional(@NotNull String keyString) {
        NamespacedKey key = NamespacedKey.fromString((String)keyString);
        if (key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Keyed)this.registry.get(key));
    }
}

