/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.util.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Keyed;
import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistriesHolder
implements Iterable<Registry<? extends Keyed>> {
    @NotNull
    private final Map<String, Registry<? extends Keyed>> registries = new HashMap<String, Registry<? extends Keyed>>();

    @NotNull
    public Collection<Registry<? extends Keyed>> getCollection() {
        return this.registries.values();
    }

    @Override
    @NotNull
    public Iterator<Registry<? extends Keyed>> iterator() {
        return this.registries.values().iterator();
    }

    private RegistriesHolder() {
    }

    @Nullable
    public Registry<?> get(@NotNull String key) {
        return this.registries.get(key);
    }

    @Nullable
    public <T extends Keyed> Registry<T> getAsType(@NotNull String key) {
        try {
            return this.registries.get(key);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @NotNull
    public <T extends Keyed> Registry<T> addRegistry(@NotNull String key, @NotNull Registry<T> registry) {
        if (this.registries.containsKey(key)) {
            return registry;
        }
        this.registries.put(key, registry);
        return registry;
    }

    @NotNull
    public <T extends Keyed> Optional<Registry<T>> getOptional(@Nullable String key) {
        Registry<? extends Keyed> r;
        if (key == null) {
            return Optional.empty();
        }
        try {
            r = this.registries.get(key);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.ofNullable(r);
    }

    public static class Builder {
        private final RegistriesHolder holder = new RegistriesHolder();

        @NotNull
        public Builder addRegistry(@NotNull String key, @NotNull Registry<? extends Keyed> registry) {
            if (this.holder.registries.containsKey(key)) {
                return this;
            }
            this.holder.registries.put(key, registry);
            return this;
        }

        @NotNull
        public RegistriesHolder build() {
            return this.holder;
        }
    }
}

