/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.endEvent;

import java.io.IOException;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.commandAPI.CommandAPICommand;
import net.mathias2246.buildmc.commandAPI.executors.ExecutorType;
import net.mathias2246.buildmc.commands.CustomCommand;
import net.mathias2246.buildmc.endEvent.EndListener;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EndEventCommand
implements CustomCommand {
    private final BukkitAudiences audiences;

    public EndEventCommand(BukkitAudiences audiences) {
        this.audiences = audiences;
    }

    @Override
    public CommandAPICommand getCommand() {
        return ((CommandAPICommand)new CommandAPICommand("endevent").withPermission("buildmc.admin")).withSubcommand(this.getSubCommand("open", true)).withSubcommand(this.getSubCommand("close", false));
    }

    private CommandAPICommand getSubCommand(String name, boolean allowEnd) {
        return (CommandAPICommand)new CommandAPICommand(name).executes(command -> {
            EndListener.allowEnd = allowEnd;
            Main.config.set("end-event.allow-end", (Object)allowEnd);
            try {
                Main.config.save(Main.configFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String senderMessageKey = allowEnd ? "messages.end-event.opened" : "messages.end-event.closed";
            TranslatableComponent senderMessage = Component.translatable(senderMessageKey);
            this.audiences.sender((CommandSender)command.sender()).sendMessage(senderMessage);
            String messageKey = allowEnd ? "messages.end-event.broadcast-opened" : "messages.end-event.broadcast-closed";
            for (Player player : Bukkit.getOnlinePlayers()) {
                TranslatableComponent msg = Component.translatable(messageKey);
                this.audiences.player(player).sendMessage(msg);
            }
        }, new ExecutorType[0]);
    }
}

